/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import com.lovetropics.extras.ExtraBlocks;
import com.lovetropics.extras.block.CustomBarrierBlock;
import com.lovetropics.lib.permission.PermissionsApi;
import com.lovetropics.lib.permission.role.Role;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class RoleBarrierBlock
extends CustomBarrierBlock
implements EntityBlock {
    public RoleBarrierBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Level lv;
        if (world instanceof Level && (lv = (Level)world).isClientSide()) {
            return Shapes.empty();
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof RoleBarrierBE) {
            RoleBarrierBE be = (RoleBarrierBE)blockEntity;
            boolean allow = be.blacklist;
            if (context instanceof EntityCollisionContext) {
                EntityCollisionContext ctx = (EntityCollisionContext)context;
                for (Role role : PermissionsApi.lookup().byEntity(ctx.getEntity())) {
                    if (!be.roles.contains(role.id())) continue;
                    allow = !allow;
                    break;
                }
            }
            if (allow) {
                return Shapes.empty();
            }
        }
        return super.getCollisionShape(state, world, pos, context);
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getShape(state, world, pos, context);
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new RoleBarrierBE((BlockEntityType)ExtraBlocks.ROLE_BARRIER.getSibling(Registries.BLOCK_ENTITY_TYPE).get(), blockPos, blockState);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Component stackName = stack.getCustomName();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RoleBarrierBE) {
            RoleBarrierBE be = (RoleBarrierBE)blockEntity;
            if (stackName != null) {
                String name = stackName.getString();
                boolean blacklist = false;
                if (name.startsWith("!")) {
                    name = name.substring(1);
                    blacklist = true;
                }
                be.blacklist = blacklist;
                be.roles = Arrays.stream(name.split(",")).map(String::trim).toList();
                be.setChanged();
            }
        }
    }

    public static final class RoleBarrierBE
    extends BlockEntity {
        private List<String> roles = List.of();
        private boolean blacklist;

        public RoleBarrierBE(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
            super(type, pos, blockState);
        }

        protected void saveAdditional(ValueOutput output) {
            super.saveAdditional(output);
            output.putBoolean("blacklist", this.blacklist);
            ValueOutput.TypedOutputList roles = output.list("roles", (Codec)Codec.STRING);
            this.roles.forEach(arg_0 -> ((ValueOutput.TypedOutputList)roles).add(arg_0));
        }

        protected void loadAdditional(ValueInput input) {
            super.loadAdditional(input);
            this.blacklist = input.getBooleanOr("blacklist", false);
            this.roles = input.listOrEmpty("roles", (Codec)Codec.STRING).stream().toList();
        }
    }
}

