/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import com.lovetropics.extras.block.entity.SeatEntity;
import com.lovetropics.extras.entity.ExtraEntities;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class SeatBlock
extends SlabBlock {
    public static final MapCodec<SeatBlock> CODEC = SeatBlock.simpleCodec(SeatBlock::new);

    public SeatBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        List foundSeats = level.getEntitiesOfClass(SeatEntity.class, new AABB(pos));
        if (!foundSeats.isEmpty() && !foundSeats.stream().allMatch(seat -> seat.getPassengers().isEmpty())) {
            return InteractionResult.FAIL;
        }
        SeatEntity seatEntity = new SeatEntity((EntityType)ExtraEntities.SEAT.get(), level);
        seatEntity.setPos((float)pos.getX() + 0.5f, pos.getY(), (float)pos.getZ() + 0.5f);
        level.addFreshEntity((Entity)seatEntity);
        player.startRiding((Entity)seatEntity);
        return InteractionResult.SUCCESS;
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.getItemInHand();
        if (itemstack.is(this.asItem())) {
            return false;
        }
        return super.canBeReplaced(state, useContext);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public MapCodec<? extends SlabBlock> codec() {
        return CODEC;
    }
}

