/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import com.lovetropics.extras.ExtraBlocks;
import com.lovetropics.extras.ExtraDataComponents;
import com.lovetropics.extras.block.entity.TeleportPadBlockEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="ltextras")
public class TeleportPadBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<TeleportPadBlock> CODEC = TeleportPadBlock.simpleCodec(TeleportPadBlock::new);
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE_BOTTOM = Block.column((double)16.0, (double)0.0, (double)8.0);
    private static final VoxelShape SHAPE_TOP = Block.column((double)16.0, (double)8.0, (double)16.0);

    public TeleportPadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)Half.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<TeleportPadBlock> codec() {
        return CODEC;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.DEBUG_STICK) && player.canUseGameMasterBlocks()) {
            if (!level.isClientSide() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.sendSystemMessage((Component)Component.literal((String)"Right-click with the debug stick at the desired teleporting location"));
                stack.set((DataComponentType)ExtraDataComponents.TELEPORT_PAD.get(), (Object)pos);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity blockEntity;
        BlockPos teleportPadPos = (BlockPos)event.getItemStack().remove((DataComponentType)ExtraDataComponents.TELEPORT_PAD.get());
        if (teleportPadPos == null) {
            return;
        }
        Level level = event.getLevel();
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(teleportPadPos)) instanceof TeleportPadBlockEntity) {
            TeleportPadBlockEntity teleportPad = (TeleportPadBlockEntity)blockEntity;
            teleportPad.updateTarget(event.getHitVec().getLocation());
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.sendSystemMessage((Component)Component.literal((String)"Set teleporting location"));
            }
        }
        event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        BlockEntity blockEntity;
        BlockPos teleportPadPos = (BlockPos)event.getItemStack().remove((DataComponentType)ExtraDataComponents.TELEPORT_PAD.get());
        if (teleportPadPos == null) {
            return;
        }
        Level level = event.getLevel();
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(teleportPadPos)) instanceof TeleportPadBlockEntity) {
            TeleportPadBlockEntity teleportPad = (TeleportPadBlockEntity)blockEntity;
            teleportPad.updateTarget(event.getEntity().position());
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.sendSystemMessage((Component)Component.literal((String)"Set teleporting location"));
            }
        }
        event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (level.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TeleportPadBlockEntity) {
            TeleportPadBlockEntity teleportPad = (TeleportPadBlockEntity)blockEntity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Vec3 targetPos = teleportPad.getTargetPos();
                if (targetPos == null) {
                    return;
                }
                level.gameEvent((Holder)GameEvent.TELEPORT, pos, GameEvent.Context.of((Entity)entity));
                Entity teleportedEntity = entity.teleport(new TeleportTransition(serverLevel, targetPos, entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), TeleportTransition.DO_NOTHING));
                if (teleportedEntity != null) {
                    teleportedEntity.resetFallDistance();
                }
                level.playSound(null, entity, SoundEvents.PLAYER_TELEPORT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Direction clickedFace = context.getClickedFace();
        boolean onTopHalf = context.getClickLocation().y - (double)pos.getY() > 0.5;
        FluidState fluidstate = context.getLevel().getFluidState(pos);
        return (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)(clickedFace == Direction.DOWN || clickedFace != Direction.UP && onTopHalf ? Half.TOP : Half.BOTTOM))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Half)state.getValue(HALF)) {
            default -> throw new MatchException(null, null);
            case Half.BOTTOM -> SHAPE_BOTTOM;
            case Half.TOP -> SHAPE_TOP;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, WATERLOGGED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TeleportPadBlockEntity((BlockEntityType)ExtraBlocks.TELEPORT_PAD_ENTITY.get(), pos, state);
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }
}

