/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;

public final class ThornStemBlock
extends PipeBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<ThornStemBlock> CODEC = ThornStemBlock.simpleCodec(ThornStemBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public ThornStemBlock(BlockBehaviour.Properties properties) {
        super(0.1875f, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            entity.hurtServer(serverLevel, entity.damageSources().sweetBerryBush(), 1.0f);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnectAlong((BlockGetter)world, pos, Direction.NORTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.canConnectAlong((BlockGetter)world, pos, Direction.EAST)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnectAlong((BlockGetter)world, pos, Direction.SOUTH)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.canConnectAlong((BlockGetter)world, pos, Direction.WEST)))).setValue((Property)UP, (Comparable)Boolean.valueOf(this.canConnectAlong((BlockGetter)world, pos, Direction.UP)))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(this.canConnectAlong((BlockGetter)world, pos, Direction.DOWN)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).getType() == Fluids.WATER));
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        BooleanProperty property = (BooleanProperty)PROPERTY_BY_DIRECTION.get(direction);
        boolean connected = this.canConnectTo((BlockGetter)level, neighborPos, direction.getOpposite());
        return (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(connected));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    private boolean canConnectAlong(BlockGetter world, BlockPos pos, Direction direction) {
        BlockPos adjacentPos = pos.relative(direction);
        BlockState adjacentState = world.getBlockState(adjacentPos);
        return this.canConnectTo(adjacentState, world, adjacentPos, direction);
    }

    private boolean canConnectTo(BlockGetter world, BlockPos pos, Direction direction) {
        return this.canConnectTo(world.getBlockState(pos), world, pos, direction);
    }

    private boolean canConnectTo(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return state.is((Block)this) || state.isFaceSturdy(world, pos, direction);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, WATERLOGGED});
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    protected MapCodec<? extends PipeBlock> codec() {
        return CODEC;
    }
}

