/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TransparentLeavesBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final MapCodec<TransparentLeavesBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ExtraCodecs.floatRange((float)0.0f, (float)1.0f).fieldOf("leaf_particle_chance").forGetter(b -> Float.valueOf(b.leafParticleChance)), (App)ParticleTypes.CODEC.fieldOf("leaf_particle").forGetter(b -> b.leafParticle), (App)TransparentLeavesBlock.propertiesCodec()).apply((Applicative)i, TransparentLeavesBlock::new));
    private static final ColorParticleOption TROPICS_LEAF_PARTICLE = ColorParticleOption.create((ParticleType)ParticleTypes.TINTED_LEAVES, (int)-15098608);
    private final float leafParticleChance;
    private final ParticleOptions leafParticle;

    public TransparentLeavesBlock(float leafParticleChance, ParticleOptions leafParticle, BlockBehaviour.Properties properties) {
        super(properties);
        this.leafParticleChance = leafParticleChance;
        this.leafParticle = leafParticle;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static TransparentLeavesBlock tropicsLeaves(BlockBehaviour.Properties properties) {
        return new TransparentLeavesBlock(0.01f, (ParticleOptions)TROPICS_LEAF_PARTICLE, properties);
    }

    public MapCodec<TransparentLeavesBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getBlockSupportShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.empty();
    }

    protected boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction neighborDirection, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return state;
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        BlockPos belowPos = pos.below();
        BlockState blockBelow = level.getBlockState(belowPos);
        TransparentLeavesBlock.makeDrippingWaterParticles(level, pos, random, blockBelow, belowPos);
        this.makeFallingLeavesParticles(level, pos, random, blockBelow, belowPos);
    }

    private static void makeDrippingWaterParticles(Level level, BlockPos pos, RandomSource random, BlockState blockBelow, BlockPos belowPos) {
        if (!(!level.isRainingAt(pos.above()) || random.nextInt(15) != 1 || blockBelow.canOcclude() && blockBelow.isFaceSturdy((BlockGetter)level, belowPos, Direction.UP))) {
            ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)pos, (RandomSource)random, (ParticleOptions)ParticleTypes.DRIPPING_WATER);
        }
    }

    private void makeFallingLeavesParticles(Level level, BlockPos pos, RandomSource random, BlockState blockBelow, BlockPos belowPos) {
        if (random.nextFloat() >= this.leafParticleChance) {
            return;
        }
        if (!TransparentLeavesBlock.isFaceFull((VoxelShape)blockBelow.getCollisionShape((BlockGetter)level, belowPos), (Direction)Direction.UP)) {
            ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)pos, (RandomSource)random, (ParticleOptions)this.leafParticle);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }
}

