/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block.entity;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class DisplayBlockEntity
extends BlockEntity {
    private static final String ITEM = "item";
    private static final String FILTER = "filter";
    private static final String TIME_TO_CONVERT = "time_to_convert";
    private static final String CONVERSION_PROGRESS = "conversion_progress";
    private static final String COMPONENTS_TO_REMOVE = "components_to_remove";
    private static final int DEFAULT_TIME_TO_CONVERT = 40;
    private ItemStack itemStack = ItemStack.EMPTY;
    private ItemPredicate filter = ItemPredicate.Builder.item().build();
    private int timeToConvert = 40;
    private int conversionProgress = 0;
    private List<DataComponentType<?>> componentsToRemove = new ArrayList();

    public DisplayBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, DisplayBlockEntity displayBlockEntity) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Optional<ItemStack> outputItemOpt = displayBlockEntity.getOutputItem();
        if (displayBlockEntity.itemStack.isEmpty() || outputItemOpt.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)displayBlockEntity.itemStack, (ItemStack)outputItemOpt.get())) {
            return;
        }
        ++displayBlockEntity.conversionProgress;
        BlockPos blockPos = displayBlockEntity.getBlockPos();
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.SPLASH.getType(), (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 1.25, (double)blockPos.getZ() + 0.5, 5, 0.0, 0.0, 0.0, 1.0);
        if (displayBlockEntity.conversionProgress >= displayBlockEntity.timeToConvert) {
            displayBlockEntity.itemStack = outputItemOpt.get().copy();
            displayBlockEntity.conversionProgress = 0;
        }
        displayBlockEntity.level.sendBlockUpdated(displayBlockEntity.getBlockPos(), displayBlockEntity.getBlockState(), displayBlockEntity.getBlockState(), 3);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag compoundtag = super.getUpdateTag(provider);
        RegistryOps registryops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (!this.itemStack.isEmpty()) {
            compoundtag.store(ITEM, ItemStack.CODEC, (DynamicOps)registryops, (Object)this.itemStack);
        }
        compoundtag.putInt(TIME_TO_CONVERT, this.timeToConvert);
        compoundtag.putInt(CONVERSION_PROGRESS, this.conversionProgress);
        compoundtag.store(FILTER, ItemPredicate.CODEC, (DynamicOps)registryops, (Object)this.filter);
        compoundtag.store(COMPONENTS_TO_REMOVE, DataComponentType.CODEC.listOf(), (DynamicOps)registryops, this.componentsToRemove);
        return compoundtag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.itemStack = input.read(ITEM, ItemStack.CODEC).orElse(ItemStack.EMPTY);
        this.timeToConvert = input.getIntOr(TIME_TO_CONVERT, 40);
        this.conversionProgress = input.getIntOr(CONVERSION_PROGRESS, 0);
        this.filter = input.read(FILTER, ItemPredicate.CODEC).orElse(ItemPredicate.Builder.item().build());
        this.componentsToRemove = input.read(COMPONENTS_TO_REMOVE, DataComponentType.CODEC.listOf()).orElse(Collections.emptyList());
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        if (!this.itemStack.isEmpty()) {
            output.store(ITEM, ItemStack.CODEC, (Object)this.itemStack);
        }
        output.putInt(CONVERSION_PROGRESS, this.conversionProgress);
        output.store(FILTER, ItemPredicate.CODEC, (Object)this.filter);
        output.putInt(TIME_TO_CONVERT, this.timeToConvert);
        output.store(COMPONENTS_TO_REMOVE, DataComponentType.CODEC.listOf(), this.componentsToRemove);
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public ItemPredicate getFilter() {
        return this.filter;
    }

    public void setConversionProgress(int conversionProgress) {
        this.conversionProgress = conversionProgress;
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public Optional<ItemStack> getOutputItem() {
        if (this.componentsToRemove.isEmpty()) {
            return Optional.empty();
        }
        ItemStack outputStack = this.itemStack.copy();
        for (DataComponentType<?> componentType : this.componentsToRemove) {
            outputStack.remove(componentType);
            this.setDefault(outputStack, componentType);
        }
        return Optional.of(outputStack);
    }

    private <T> void setDefault(ItemStack itemStack, DataComponentType<T> componentType) {
        ItemStack defaultStack = new ItemStack((ItemLike)itemStack.getItem());
        if (defaultStack.has(componentType)) {
            itemStack.set(componentType, defaultStack.get(componentType));
        }
    }
}

