/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block.entity;

import com.lovetropics.extras.block.JumpPadBlock;
import com.lovetropics.extras.block.TrajectorySolver;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class JumpPadBlockEntity
extends BlockEntity {
    private static final String TAG_TARGET_POS = "target";
    private static final String TAG_ANGLE = "angle";
    private static final String TAG_MAX_VELOCITY = "max_velocity";
    private static final float DEFAULT_ANGLE = 45.0f;
    private static final float DEFAULT_MAX_VELOCITY = 10.0f;
    @Nullable
    private Vec3 targetPos;
    private float angle = 45.0f;
    private float maxVelocity = 10.0f;
    @Nullable
    private Vec3 launchVelocity;

    public JumpPadBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public void updateTarget(Vec3 targetPos) {
        this.targetPos = targetPos;
        this.launchVelocity = null;
        BlockPos blockPos = this.getBlockPos();
        this.getLevel().setBlockAndUpdate(blockPos, (BlockState)this.getBlockState().setValue(JumpPadBlock.FACING, (Comparable)JumpPadBlockEntity.getDirectionToTarget(targetPos, blockPos)));
    }

    private static Direction getDirectionToTarget(Vec3 targetPos, BlockPos blockPos) {
        double deltaX = targetPos.x - (double)blockPos.getX() - 0.5;
        double deltaZ = targetPos.z - (double)blockPos.getZ() - 0.5;
        if (Math.abs(deltaX) < 0.5 && Math.abs(deltaZ) < 0.5) {
            return Direction.UP;
        }
        if (Math.abs(deltaX) > Math.abs(deltaZ)) {
            return deltaX > 0.0 ? Direction.EAST : Direction.WEST;
        }
        return deltaZ > 0.0 ? Direction.SOUTH : Direction.NORTH;
    }

    public Vec3 getLaunchVelocity() {
        if (this.launchVelocity == null) {
            this.launchVelocity = this.computeLaunchVelocity();
        }
        return this.launchVelocity;
    }

    private Vec3 computeLaunchVelocity() {
        if (this.targetPos == null) {
            return Vec3.ZERO;
        }
        Vec3 origin = Vec3.atCenterOf((Vec3i)this.getBlockPos());
        if (this.getBlockState().getValue(JumpPadBlock.HALF) == Half.TOP) {
            origin = origin.add(0.0, 0.5, 0.0);
        }
        return TrajectorySolver.STANDARD.solveVelocity(origin, this.targetPos, (double)(this.angle * ((float)Math.PI / 180)), true, (double)this.maxVelocity);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.targetPos = input.read(TAG_TARGET_POS, Vec3.CODEC).orElse(null);
        this.angle = input.getFloatOr(TAG_ANGLE, 45.0f);
        this.maxVelocity = input.getFloatOr(TAG_MAX_VELOCITY, 10.0f);
        this.launchVelocity = null;
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.storeNullable(TAG_TARGET_POS, Vec3.CODEC, (Object)this.targetPos);
        output.putFloat(TAG_ANGLE, this.angle);
        output.putFloat(TAG_MAX_VELOCITY, this.maxVelocity);
    }
}

