/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block.entity;

import com.lovetropics.extras.entity.ExtendedCreatureEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class MobControllerBlockEntity
extends BlockEntity {
    public boolean loadState = true;
    public final List<UUID> uuids = new ArrayList<UUID>();
    public final Map<UUID, EntityType<?>> types = new HashMap();
    public final Map<UUID, Vec3> positions = new HashMap<UUID, Vec3>();

    public MobControllerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        List mobConfigs = input.read("Mobs", MobConfig.CODEC.listOf()).orElse(List.of());
        this.uuids.clear();
        this.types.clear();
        this.positions.clear();
        for (MobConfig mobConfig : mobConfigs) {
            this.uuids.add(mobConfig.uuid());
            this.types.put(mobConfig.uuid(), mobConfig.type());
            this.positions.put(mobConfig.uuid(), mobConfig.pos());
        }
        this.loadState = input.getBooleanOr("LoadState", false);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        ArrayList<MobConfig> mobConfigs = new ArrayList<MobConfig>();
        for (UUID uuid : this.uuids) {
            mobConfigs.add(new MobConfig(uuid, this.types.get(uuid), this.positions.get(uuid)));
        }
        output.store("Mobs", MobConfig.CODEC.listOf(), mobConfigs);
        output.putBoolean("LoadState", this.loadState);
    }

    public void addEntity(Entity entity) {
        if (entity instanceof ExtendedCreatureEntity) {
            ExtendedCreatureEntity ex = (ExtendedCreatureEntity)entity;
            ex.linkToBlockEntity(this);
            UUID uuid = entity.getUUID();
            this.uuids.add(uuid);
            this.types.put(uuid, entity.getType());
            this.positions.put(uuid, entity.position());
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MobControllerBlockEntity controller) {
        block6: {
            Player player;
            ServerLevel serverLevel;
            block7: {
                if (!(level instanceof ServerLevel)) break block6;
                serverLevel = (ServerLevel)level;
                long ticks = level.getGameTime();
                if (controller.loadState && ticks % 5L == 0L) {
                    for (UUID uuid : controller.uuids) {
                        Entity entity = serverLevel.getEntity(uuid);
                        if (entity == null) continue;
                        controller.positions.put(uuid, entity.position());
                    }
                }
                if (ticks % 20L != 0L) break block6;
                player = level.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 32.0, EntitySelector.NO_SPECTATORS);
                if (!controller.loadState) break block7;
                if (player != null) break block6;
                controller.loadState = false;
                for (UUID uuid : controller.uuids) {
                    Entity entity = serverLevel.getEntity(uuid);
                    if (entity == null) continue;
                    entity.discard();
                }
                break block6;
            }
            if (player != null) {
                controller.loadState = true;
                for (UUID uuid : controller.uuids) {
                    Entity entity = controller.types.get(uuid).create((Level)serverLevel, EntitySpawnReason.MOB_SUMMONED);
                    Vec3 mobPos = controller.positions.get(uuid);
                    if (entity == null) continue;
                    entity.snapTo(mobPos, 0.0f, 0.0f);
                    entity.setUUID(uuid);
                    level.addFreshEntity(entity);
                    if (entity instanceof Mob) {
                        Mob mob = (Mob)entity;
                        mob.finalizeSpawn((ServerLevelAccessor)serverLevel, level.getCurrentDifficultyAt(pos), EntitySpawnReason.MOB_SUMMONED, null);
                    }
                    if (!(entity instanceof ExtendedCreatureEntity)) continue;
                    ExtendedCreatureEntity extended = (ExtendedCreatureEntity)entity;
                    extended.linkToBlockEntity(controller);
                }
            }
        }
    }

    public record MobConfig(UUID uuid, EntityType<?> type, Vec3 pos) {
        public static final Codec<MobConfig> CODEC = RecordCodecBuilder.create(i -> i.group((App)UUIDUtil.CODEC.fieldOf("uuid").forGetter(MobConfig::uuid), (App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("type").forGetter(MobConfig::type), (App)Vec3.CODEC.fieldOf("pos").forGetter(MobConfig::pos)).apply((Applicative)i, MobConfig::new));
    }
}

