/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.click_events;

import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.click_events.ExtraClickEvent;
import com.lovetropics.extras.click_events.MountClickEvent;
import com.lovetropics.extras.click_events.RunFunctionClickEvent;
import com.lovetropics.lib.codec.CodecRegistry;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;

public class ExtraClickEvents {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final CodecRegistry<ResourceLocation, MapCodec<? extends ExtraClickEvent>> REGISTRY = (CodecRegistry)Util.make((Object)CodecRegistry.resourceLocationKeys(), registry -> {
        registry.register((Object)LTExtras.location("run_function"), RunFunctionClickEvent.CODEC);
        registry.register((Object)LTExtras.location("mount_entity"), MountClickEvent.CODEC);
    });

    public static void handleCustomClickAction(ServerPlayer serverPlayer, ResourceLocation location, Optional<Tag> tag) {
        MapCodec mapCodec = (MapCodec)REGISTRY.get((Object)location);
        if (mapCodec == null) {
            ExtraClickEvents.sendErrorMessage(serverPlayer, "Unknown click action: " + String.valueOf(location));
            LOGGER.error("Received unknown click action location: {}", (Object)location);
            return;
        }
        Tag input = tag.orElse((Tag)new CompoundTag());
        try {
            ((ExtraClickEvent)mapCodec.codec().parse((DynamicOps)NbtOps.INSTANCE, (Object)input).getOrThrow()).handleAction(serverPlayer, input, arg_0 -> ((ServerPlayer)serverPlayer).sendSystemMessage(arg_0));
        }
        catch (Exception e) {
            ExtraClickEvents.sendErrorMessage(serverPlayer, "Failed to decode click action payload for action: " + String.valueOf(location));
            LOGGER.error("Failed to decode click action payload for location: {}", (Object)location, (Object)e);
        }
    }

    private static void sendErrorMessage(ServerPlayer serverPlayer, String message) {
        serverPlayer.sendSystemMessage((Component)Component.literal((String)message).withStyle(ChatFormatting.RED));
    }
}

