/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.click_events;

import com.lovetropics.extras.click_events.ExtraClickEvent;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.SummonCommand;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;

public record MountClickEvent(ResourceKey<EntityType<?>> type, Optional<CompoundTag> nbt) implements ExtraClickEvent
{
    public static final MapCodec<MountClickEvent> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ResourceKey.codec((ResourceKey)Registries.ENTITY_TYPE).fieldOf("type").forGetter(MountClickEvent::type), (App)CompoundTag.CODEC.optionalFieldOf("nbt").forGetter(MountClickEvent::nbt)).apply((Applicative)i, MountClickEvent::new));

    @Override
    public void handleAction(ServerPlayer serverPlayer, Tag tag, Consumer<Component> errorHandler) {
        Optional entityTypeReference = serverPlayer.registryAccess().get(this.type);
        if (entityTypeReference.isEmpty()) {
            errorHandler.accept((Component)Component.literal((String)("Entity type not found in registry: " + String.valueOf(this.type.location()))));
            return;
        }
        Holder.Reference holder = (Holder.Reference)entityTypeReference.get();
        try {
            Entity spawnEntity = SummonCommand.createEntity((CommandSourceStack)serverPlayer.createCommandSourceStackForNameResolution(serverPlayer.level()), (Holder.Reference)holder, (Vec3)serverPlayer.position(), (CompoundTag)this.nbt.orElse(new CompoundTag()), (boolean)false);
            serverPlayer.startRiding(spawnEntity, true);
            spawnEntity.addTag("remove_on_dismount");
        }
        catch (CommandSyntaxException e) {
            errorHandler.accept((Component)Component.literal((String)("Failed to summon entity: " + e.getMessage())));
        }
    }

    @Override
    public MapCodec<? extends ExtraClickEvent> getCodec() {
        return CODEC;
    }
}

