/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.click_events;

import com.lovetropics.extras.click_events.ExtraClickEvent;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public record RunFunctionClickEvent(ResourceLocation function) implements ExtraClickEvent
{
    public static final MapCodec<RunFunctionClickEvent> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("function").forGetter(RunFunctionClickEvent::function)).apply((Applicative)instance, RunFunctionClickEvent::new));

    @Override
    public void handleAction(ServerPlayer serverPlayer, Tag tag, Consumer<Component> errorHandler) {
        MinecraftServer server = serverPlayer.getServer();
        CommandFunction commandFunction = (CommandFunction)server.getFunctions().get(this.function).orElseThrow();
        try {
            CompoundTag compound = tag.asCompound().orElse(new CompoundTag());
            InstantiatedFunction instantiate = commandFunction.instantiate(compound, server.getCommands().getDispatcher());
            CommandSourceStack commandSourceStack = serverPlayer.createCommandSourceStack();
            Commands.executeCommandInContext((CommandSourceStack)commandSourceStack, executionContext -> ExecutionContext.queueInitialFunctionCall((ExecutionContext)executionContext, (InstantiatedFunction)instantiate, (ExecutionCommandSource)commandSourceStack, (CommandResultCallback)CommandResultCallback.EMPTY));
        }
        catch (FunctionInstantiationException e) {
            errorHandler.accept((Component)Component.literal((String)e.getMessage()));
        }
    }

    @Override
    public MapCodec<? extends ExtraClickEvent> getCodec() {
        return CODEC;
    }
}

