/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client;

import com.lovetropics.extras.client.screen.ServerClosedScreen;
import com.lovetropics.extras.rejoiner.AutoRejoinIntent;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.DisconnectionDetails;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="ltextras")
public class ClientAutoRejoinHandler {
    private static AutoRejoinIntent intent = AutoRejoinIntent.DISABLE;

    public static void handleIntent(AutoRejoinIntent intent) {
        ClientAutoRejoinHandler.intent = intent;
    }

    @SubscribeEvent
    public static void onDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        intent = AutoRejoinIntent.DISABLE;
    }

    @Nullable
    public static Screen createConnectionClosedScreen(DisconnectionDetails details, ServerData server) {
        ServerClosedScreen.Type type;
        switch (intent) {
            default: {
                throw new MatchException(null, null);
            }
            case DISABLE: {
                ServerClosedScreen.Type type2 = null;
                break;
            }
            case ENABLE: {
                ServerClosedScreen.Type type2 = ServerClosedScreen.Type.UNEXPECTED;
                break;
            }
            case RESTART_SERVER: {
                ServerClosedScreen.Type type2 = ServerClosedScreen.Type.SERVER_RESTART;
                break;
            }
            case RESTART_SERVER_AND_CLIENT: {
                ServerClosedScreen.Type type2 = ServerClosedScreen.Type.CLIENT_RESTART;
                break;
            }
            case SHUT_DOWN_PERMANENT: {
                ServerClosedScreen.Type type2 = type = ServerClosedScreen.Type.PERMANENT;
            }
        }
        if (type != null) {
            return new ServerClosedScreen(type, details, server);
        }
        return null;
    }
}

