/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client;

import com.lovetropics.extras.client.CollectibleToast;
import com.lovetropics.extras.client.screen.container.CollectibleBasketScreen;
import com.lovetropics.extras.collectible.Collectible;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;

@EventBusSubscriber(modid="ltextras", value={Dist.CLIENT})
public class ClientCollectiblesList {
    @Nullable
    private static ClientCollectiblesList instance;
    private List<Holder<Collectible>> collectibles = List.of();
    private List<ItemStack> itemStacks = List.of();
    private boolean hasUnseen;

    public static ClientCollectiblesList get() {
        return Objects.requireNonNull(instance, "Cannot get collectibles list, not currently in a world");
    }

    @Nullable
    public static ClientCollectiblesList getOrNull() {
        return instance;
    }

    @SubscribeEvent
    public static void onLogIn(ClientPlayerNetworkEvent.LoggingIn event) {
        instance = new ClientCollectiblesList();
    }

    @SubscribeEvent
    public static void onLogOut(ClientPlayerNetworkEvent.LoggingOut event) {
        instance = null;
    }

    public List<Holder<Collectible>> collectibles() {
        return this.collectibles;
    }

    public List<ItemStack> itemStacks() {
        return this.itemStacks;
    }

    public void update(List<Holder<Collectible>> collectibles, boolean silent, boolean hasUnseen) {
        Minecraft minecraft = Minecraft.getInstance();
        List<Holder<Collectible>> newCollectibles = collectibles.stream().filter(c -> !this.collectibles.contains(c)).toList();
        this.collectibles = List.copyOf(collectibles);
        UUID playerId = minecraft.player.getUUID();
        this.itemStacks = collectibles.stream().map(collectible -> Collectible.createItemStack((Holder<Collectible>)collectible, playerId)).toList();
        if (!silent && !newCollectibles.isEmpty()) {
            ClientCollectiblesList.notifyCollections(newCollectibles);
        }
        this.hasUnseen = hasUnseen;
    }

    private static void notifyCollections(List<Holder<Collectible>> newCollectibles) {
        Minecraft minecraft = Minecraft.getInstance();
        for (Holder<Collectible> newCollectible : newCollectibles) {
            minecraft.getToastManager().addToast((Toast)new CollectibleToast(newCollectible));
        }
        minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.EXPERIENCE_ORB_PICKUP, (float)1.0f));
    }

    public static void openScreen() {
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.setScreen((Screen)new CollectibleBasketScreen(minecraft.player.getInventory()));
        ClientCollectiblesList.get().hasUnseen = false;
    }

    public boolean isEmpty() {
        return this.collectibles.isEmpty();
    }

    public boolean hasUnseen() {
        return this.hasUnseen;
    }
}

