/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client;

import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.item.sensor.PlayerSensor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.client.renderstate.RegisterRenderStateModifiersEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@EventBusSubscriber(modid="ltextras", value={Dist.CLIENT})
public class ClientPlayerSensorEffects {
    private static final ResourceLocation MARKER_BOX_SPRITE = LTExtras.location("marker_box");
    private static final int MARKER_BOX_INNER_PADDING = 32;
    private static final ContextKey<UUID> UUID_KEY = new ContextKey(LTExtras.location("uuid"));
    private static final int VISIBLE_REFRESH_INTERVAL = 10;
    private static final Map<UUID, PlayerSensor.Appearance> MARKED_PLAYERS = new Object2ObjectOpenHashMap();
    private static final Set<UUID> VISIBLE_MARKED_PLAYERS = new ObjectArraySet();
    private static final List<CapturedScreenBoxes> CAPTURED_SCREEN_POS = new ArrayList<CapturedScreenBoxes>();
    private static Matrix4f capturedProjectionMatrix = new Matrix4f();

    public static void mark(int entityId, PlayerSensor.Appearance appearance) {
        Entity entity;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && (entity = level.getEntity(entityId)) instanceof Player) {
            Player player = (Player)entity;
            MARKED_PLAYERS.put(player.getUUID(), appearance);
        }
    }

    public static void clear(int entityId) {
        Entity entity;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && (entity = level.getEntity(entityId)) instanceof Player) {
            Player player = (Player)entity;
            MARKED_PLAYERS.remove(player.getUUID());
        }
    }

    public static void registerGuiLayers(RegisterGuiLayersEvent event) {
        event.registerBelow(VanillaGuiLayers.CAMERA_OVERLAYS, LTExtras.location("player_sensor"), ClientPlayerSensorEffects::renderGui);
    }

    private static void renderGui(GuiGraphics graphics, DeltaTracker deltaTracker) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        for (CapturedScreenBoxes capturedScreenBoxes : CAPTURED_SCREEN_POS) {
            UUID playerId = capturedScreenBoxes.playerId;
            Player target = level.getPlayerByUUID(playerId);
            PlayerSensor.Appearance appearance = MARKED_PLAYERS.get(playerId);
            if (target == null || appearance == null) continue;
            ClientPlayerSensorEffects.renderGuiMarker(graphics, capturedScreenBoxes, appearance);
        }
        CAPTURED_SCREEN_POS.clear();
    }

    private static void renderGuiMarker(GuiGraphics graphics, CapturedScreenBoxes screenBoxes, PlayerSensor.Appearance appearance) {
        GuiBox face = screenBoxes.face.toGui(graphics);
        int faceSize = Math.max(face.width(), face.height());
        float alpha = Mth.clampedMap((float)faceSize, (float)10.0f, (float)20.0f, (float)0.0f, (float)1.0f);
        if (alpha <= 1.0E-5f) {
            return;
        }
        int faceBoxSize = faceSize + 32;
        int markerColor = ARGB.color((float)alpha, (int)appearance.color());
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, MARKER_BOX_SPRITE, face.centerX() - faceBoxSize / 2, face.centerY() - faceBoxSize / 2, faceBoxSize, faceBoxSize, markerColor);
        Optional<PlayerSensor.Sprite> faceSprite = appearance.faceDecoration();
        if (faceSprite.isPresent()) {
            int spriteWidth = faceSprite.get().width();
            int spriteHeight = faceSprite.get().height();
            int color = ARGB.white((float)alpha);
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, faceSprite.get().location(), face.centerX() - spriteWidth / 2, face.centerY() - faceBoxSize / 2 - spriteHeight, spriteWidth, spriteHeight, color);
        }
    }

    @SubscribeEvent
    public static void onStopTracking(EntityLeaveLevelEvent event) {
        if (event.getLevel() instanceof ClientLevel) {
            MARKED_PLAYERS.remove(event.getEntity().getUUID());
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (player.tickCount % 10 == 0) {
            ClientPlayerSensorEffects.refreshVisiblePlayers(player);
        }
    }

    private static void refreshVisiblePlayers(LocalPlayer player) {
        VISIBLE_MARKED_PLAYERS.clear();
        Level level = player.level();
        for (UUID playerId : MARKED_PLAYERS.keySet()) {
            Player target = level.getPlayerByUUID(playerId);
            if (target == null || !player.hasLineOfSight((Entity)target)) continue;
            VISIBLE_MARKED_PLAYERS.add(target.getUUID());
        }
    }

    @SubscribeEvent
    public static void onRegisterRenderStateModifiers(RegisterRenderStateModifiersEvent event) {
        event.registerEntityModifier(PlayerRenderer.class, (entity, state) -> state.setRenderData(UUID_KEY, (Object)entity.getUUID()));
    }

    public static <T extends LivingEntityRenderState> void captureModelPose(T state, EntityModel<?> model, PoseStack poseStack) {
        HumanoidModel humanoidModel;
        CapturedScreenBoxes capture;
        if (state.entityType != EntityType.PLAYER) {
            return;
        }
        UUID playerId = (UUID)state.getRenderData(UUID_KEY);
        if (playerId == null || !VISIBLE_MARKED_PLAYERS.contains(playerId)) {
            return;
        }
        if (model instanceof HumanoidModel && (capture = ClientPlayerSensorEffects.capturePlayerPose(playerId, poseStack, humanoidModel = (HumanoidModel)model)) != null) {
            CAPTURED_SCREEN_POS.add(capture);
        }
    }

    @Nullable
    private static CapturedScreenBoxes capturePlayerPose(UUID entityId, PoseStack poseStack, HumanoidModel<?> humanoidModel) {
        poseStack.pushPose();
        humanoidModel.head.translateAndRotate(poseStack);
        ScreenBox faceBox = ClientPlayerSensorEffects.toScreenBox(poseStack, -4.0f, -8.0f, -4.0f, 4.0f, 0.0f, 4.0f);
        poseStack.popPose();
        if (faceBox != null) {
            return new CapturedScreenBoxes(entityId, faceBox);
        }
        return null;
    }

    @Nullable
    private static ScreenBox toScreenBox(PoseStack poseStack, float x0, float y0, float z0, float x1, float y1, float z1) {
        Vector3f[] vertices = new Vector3f[]{ClientPlayerSensorEffects.toScreenPos(poseStack, x0, y0, z0), ClientPlayerSensorEffects.toScreenPos(poseStack, x0, y0, z1), ClientPlayerSensorEffects.toScreenPos(poseStack, x0, y1, z0), ClientPlayerSensorEffects.toScreenPos(poseStack, x0, y1, z1), ClientPlayerSensorEffects.toScreenPos(poseStack, x1, y0, z0), ClientPlayerSensorEffects.toScreenPos(poseStack, x1, y0, z1), ClientPlayerSensorEffects.toScreenPos(poseStack, x1, y1, z0), ClientPlayerSensorEffects.toScreenPos(poseStack, x1, y1, z1)};
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float maxY = -3.4028235E38f;
        for (Vector3f vertex : vertices) {
            if (vertex.z >= 1.0f || vertex.z <= 0.1f) {
                return null;
            }
            if (vertex.x <= -2.0f || vertex.x >= 2.0f || vertex.y <= -2.0f || vertex.y >= 2.0f) {
                return null;
            }
            minX = Math.min(minX, vertex.x);
            minY = Math.min(minY, vertex.y);
            maxX = Math.max(maxX, vertex.x);
            maxY = Math.max(maxY, vertex.y);
        }
        return new ScreenBox(minX, minY, maxX, maxY);
    }

    public static void captureProjectionMatrix(Matrix4f projectionMatrix) {
        capturedProjectionMatrix = projectionMatrix;
    }

    private static Vector3f toScreenPos(PoseStack poseStack, float x, float y, float z) {
        Vector3f pos = new Vector3f(x, y, z).mul(0.0625f);
        poseStack.last().pose().transformPosition(pos);
        RenderSystem.getModelViewMatrix().transformPosition(pos);
        capturedProjectionMatrix.transformProject(pos);
        return pos.set((pos.x + 1.0f) / 2.0f, 1.0f - (pos.y + 1.0f) / 2.0f, pos.z);
    }

    private record CapturedScreenBoxes(UUID playerId, ScreenBox face) {
    }

    private record ScreenBox(float x0, float y0, float x1, float y1) {
        public GuiBox toGui(GuiGraphics graphics) {
            return new GuiBox(Mth.floor((float)(this.x0 * (float)graphics.guiWidth())), Mth.floor((float)(this.y0 * (float)graphics.guiHeight())), Mth.floor((float)(this.x1 * (float)graphics.guiWidth())), Mth.floor((float)(this.y1 * (float)graphics.guiHeight())));
        }
    }

    private record GuiBox(int x0, int y0, int x1, int y1) {
        public int centerX() {
            return (this.x0 + this.x1) / 2;
        }

        public int centerY() {
            return (this.y0 + this.y1) / 2;
        }

        public int width() {
            return this.x1 - this.x0;
        }

        public int height() {
            return this.y1 - this.y0;
        }
    }
}

