/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client;

import com.lovetropics.extras.ExtraDataComponents;
import com.lovetropics.extras.ExtraItems;
import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.item.ImageData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderItemInFrameEvent;
import net.neoforged.neoforge.client.renderstate.RegisterRenderStateModifiersEvent;

@EventBusSubscriber(modid="ltextras", value={Dist.CLIENT})
public class ImageRenderer {
    private static final ContextKey<ImageData> IMAGE_KEY = new ContextKey(LTExtras.location("image"));

    @SubscribeEvent
    public static void onRegisterRenderStateModifiers(RegisterRenderStateModifiersEvent event) {
        Class<ItemFrameRenderer> itemFrameRenderer = ItemFrameRenderer.class;
        event.registerEntityModifier(itemFrameRenderer, (entity, state) -> {
            ItemStack stack = entity.getItem();
            if (stack.is((Item)ExtraItems.IMAGE.get())) {
                state.setRenderData(IMAGE_KEY, (Object)((ImageData)stack.get(ExtraDataComponents.IMAGE)));
            }
        });
    }

    @SubscribeEvent
    public static void onRenderItemInFrame(RenderItemInFrameEvent event) {
        ImageData image = (ImageData)event.getItemFrameRenderState().getRenderData(IMAGE_KEY);
        if (image != null) {
            ImageRenderer.renderImage(image, event.getPoseStack().last(), event.getMultiBufferSource(), event.getPackedLight());
            event.setCanceled(true);
        }
    }

    private static void renderImage(ImageData image, PoseStack.Pose pose, MultiBufferSource bufferSource, int packedLight) {
        float x0 = -image.width() / 2.0f + image.offsetX();
        float y0 = -image.height() / 2.0f + image.offsetY();
        float x1 = image.width() / 2.0f + image.offsetX();
        float y1 = image.height() / 2.0f + image.offsetY();
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.entityCutoutNoCullZOffset((ResourceLocation)image.texture()));
        ImageRenderer.addVertex(consumer, pose, x0, y0, 1.0f, 1.0f, packedLight);
        ImageRenderer.addVertex(consumer, pose, x1, y0, 0.0f, 1.0f, packedLight);
        ImageRenderer.addVertex(consumer, pose, x1, y1, 0.0f, 0.0f, packedLight);
        ImageRenderer.addVertex(consumer, pose, x0, y1, 1.0f, 0.0f, packedLight);
    }

    private static void addVertex(VertexConsumer consumer, PoseStack.Pose pose, float x, float y, float u, float v, int packedLight) {
        consumer.addVertex(pose.pose(), x, y, 0.0f).setColor(-1).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, 0.0f, -1.0f);
    }
}

