/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client;

import com.lovetropics.extras.ExtraDataComponents;
import com.lovetropics.extras.item.PaintingOverlay;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.state.PaintingRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionfc;

public class PaintingOverlayRenderer {
    public static void renderOverlay(PaintingRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack headgear = player.getItemBySlot(EquipmentSlot.HEAD);
        List paintingOverlays = (List)headgear.get(ExtraDataComponents.PAINTING_OVERLAY);
        if (paintingOverlays != null) {
            for (PaintingOverlay paintingOverlay : paintingOverlays) {
                if (renderState.variant == null || paintingOverlay == null || paintingOverlay.painting().value() != renderState.variant) continue;
                poseStack.pushPose();
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)(180 - renderState.direction.get2DDataValue() * 90)));
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
                float scaleAdjust = (float)renderState.variant.width() / 50.0f + Mth.sin((float)((float)(player.tickCount % 32) * (float)Math.PI / 32.0f)) / 20.0f;
                if (paintingOverlay.text().isPresent()) {
                    Component textComponent = paintingOverlay.text().get();
                    int textLength = textComponent.getString().length();
                    poseStack.translate(0.0f, 0.0f, -0.1f);
                    float scale = 0.01f + scaleAdjust;
                    poseStack.scale(scale, scale, scale);
                    Minecraft.getInstance().font.drawInBatch(textComponent, (float)(-textLength * 2), -3.0f, -1, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, LightTexture.lightCoordsWithEmission((int)packedLight, (int)2));
                } else if (paintingOverlay.itemStack().isPresent()) {
                    float scale = 1.0f + scaleAdjust;
                    poseStack.scale(scale, scale, scale);
                    Minecraft.getInstance().getItemRenderer().renderStatic(paintingOverlay.itemStack().get(), ItemDisplayContext.FIXED, 15728850, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, player.level(), 0);
                }
                poseStack.popPose();
            }
        }
    }
}

