/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.block;

import com.lovetropics.extras.ExtraBlocks;
import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.block.entity.WordBoxBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.state.FallingBlockRenderState;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class WordBoxBlockEntityRenderer
implements BlockEntityRenderer<WordBoxBlockEntity> {
    public static final ContextKey<Component> KEY_COMPONENT = new ContextKey(LTExtras.location("word_box/component"));
    public static final float OFFSET = 0.01f;
    public static final float Y_OFFSET = 0.5f;
    private static final int PADDING = 5;
    private static final int TEXT_COLOR = -15331065;
    private static final float TEXT_SCALE = 0.0121f;
    private final Font font;

    public WordBoxBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.getFont();
    }

    public void render(WordBoxBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPos) {
        WordBoxBlockEntityRenderer.renderText(poseStack, bufferSource, this.font, packedLight, (Component)blockEntity.components().getOrDefault(DataComponents.CUSTOM_NAME, (Object)WordBoxBlockEntity.DEFAULT_TEXT));
    }

    public static void renderText(PoseStack poseStack, MultiBufferSource bufferSource, Font font, int packedLight, Component unstyledText) {
        MutableComponent text = unstyledText.copy().withStyle(ChatFormatting.BOLD);
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        poseStack.translate(0.0f, 0.5f, -1.01f);
        WordBoxBlockEntityRenderer.renderFaceText(poseStack, bufferSource, font, packedLight, (Component)text);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(1.0f, 0.5f, -0.01f);
        WordBoxBlockEntityRenderer.renderFaceText(poseStack, bufferSource, font, packedLight, (Component)text);
        poseStack.popPose();
    }

    private static void renderFaceText(PoseStack poseStack, MultiBufferSource bufferSource, Font font, int packedLight, Component text) {
        poseStack.scale(-0.0121f, -0.0121f, 0.0121f);
        Matrix4f pose = poseStack.last().pose();
        List lines = ComponentRenderUtils.wrapComponents((FormattedText)text, (int)(Mth.floor((float)82.64463f) - 10), (Font)font);
        int i = 0;
        for (FormattedCharSequence line : lines) {
            float f = (float)i - (float)lines.size() / 2.0f - 0.5f;
            Objects.requireNonNull(font);
            float lineY = f * 9.0f + 1.0f;
            font.drawInBatch(line, 5.0f, lineY, -15331065, false, pose, bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
            ++i;
        }
    }

    public static void updateFallingBlockRenderState(FallingBlockEntity entity, FallingBlockRenderState renderState) {
        if (entity.getBlockState().is(ExtraBlocks.WORD_BOX)) {
            try {
                if (entity.blockData != null && entity.blockData.contains("components")) {
                    Component text = (Component)DataComponentMap.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)entity.blockData.get("components")).map(pair -> (Component)((DataComponentMap)pair.getFirst()).getOrDefault(DataComponents.CUSTOM_NAME, (Object)WordBoxBlockEntity.DEFAULT_TEXT)).getOrThrow();
                    renderState.setRenderData(KEY_COMPONENT, (Object)text);
                }
            }
            catch (Exception exception) {}
        } else {
            renderState.setRenderData(KEY_COMPONENT, null);
        }
    }
}

