/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.TriState;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;

@EventBusSubscriber(modid="ltextras", value={Dist.CLIENT})
public class NameTagModeCommand {
    private static Mode mode = Mode.DEFAULT;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"nameTagMode").then(Commands.argument((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest(Arrays.stream(Mode.values()).map(Mode::getSerializedName), (SuggestionsBuilder)builder)).executes(NameTagModeCommand::setNameTagsMode)));
    }

    public static int setNameTagsMode(CommandContext<CommandSourceStack> ctx) {
        mode = (Mode)Mode.CODEC.byName(StringArgumentType.getString(ctx, (String)"mode"), (Enum)Mode.DEFAULT);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Name tag mode: " + mode.getSerializedName())), false);
        return 1;
    }

    @SubscribeEvent
    public static void onRenderNameTagEvent(RenderNameTagEvent.CanRender evt) {
        switch (mode.ordinal()) {
            case 1: {
                evt.setCanRender(TriState.FALSE);
                break;
            }
            case 2: {
                if (!(evt.getEntity() instanceof Player)) break;
                evt.setCanRender(TriState.TRUE);
                break;
            }
            case 3: {
                evt.setCanRender(TriState.TRUE);
            }
        }
    }

    public static enum Mode implements StringRepresentable
    {
        DEFAULT("default"),
        NONE("none"),
        ALL_PLAYERS("all_players"),
        ALL("all");

        public static final StringRepresentable.EnumCodec<Mode> CODEC;
        private final String id;

        private Mode(String id) {
            this.id = id;
        }

        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Mode::values);
        }
    }
}

