/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.entity;

import com.lovetropics.extras.entity.CleaningItemFrame;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.client.renderer.entity.state.ItemFrameRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.decoration.ItemFrame;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class CleaningItemFrameRender
extends ItemFrameRenderer<CleaningItemFrame> {
    public CleaningItemFrameRender(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(ItemFrameRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render(renderState, poseStack, bufferSource, packedLight);
        if (renderState instanceof CleaingItemFrameRenderState) {
            CleaingItemFrameRenderState cleaningState = (CleaingItemFrameRenderState)renderState;
            this.renderProgressBar(cleaningState, (Component)Component.literal((String)(cleaningState.cleanTick + " / " + cleaningState.maxCleanTick)), poseStack, bufferSource, packedLight);
        }
    }

    protected void renderProgressBar(CleaingItemFrameRenderState renderState, Component displayName, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        boolean i = false;
        poseStack.pushPose();
        poseStack.translate(0.0f, 1.0f, 0.0f);
        poseStack.mulPose((Quaternionfc)this.entityRenderDispatcher.cameraOrientation());
        poseStack.scale(0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.last().pose();
        Font font = this.getFont();
        float f = (float)(-font.width((FormattedText)displayName)) / 2.0f;
        int j = (int)(Minecraft.getInstance().options.getBackgroundOpacity(0.25f) * 255.0f) << 24;
        font.drawInBatch(displayName, f, (float)i, -2130706433, false, matrix4f, bufferSource, Font.DisplayMode.NORMAL, j, packedLight);
        poseStack.popPose();
    }

    public ItemFrameRenderState createRenderState() {
        return new CleaingItemFrameRenderState();
    }

    public void extractRenderState(CleaningItemFrame itemFrame, ItemFrameRenderState renderState, float partialTick) {
        super.extractRenderState((ItemFrame)itemFrame, renderState, partialTick);
        if (renderState instanceof CleaingItemFrameRenderState) {
            CleaingItemFrameRenderState cleaningState = (CleaingItemFrameRenderState)renderState;
            cleaningState.cleanTick = itemFrame.getCleanTick();
            cleaningState.maxCleanTick = itemFrame.getMaxCleanTick();
        }
    }

    public static class CleaingItemFrameRenderState
    extends ItemFrameRenderState {
        public int cleanTick;
        public int maxCleanTick;
    }
}

