/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.entity;

import com.lovetropics.extras.client.entity.state.CollectibleEntityRenderState;
import com.lovetropics.extras.entity.CollectibleEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class CollectibleEntityRenderer
extends EntityRenderer<CollectibleEntity, CollectibleEntityRenderState> {
    private static final ItemDisplayContext DISPLAY_CONTEXT = ItemDisplayContext.GROUND;
    private final ItemModelResolver itemModeResolver;

    public CollectibleEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemModeResolver = context.getItemModelResolver();
        this.shadowRadius = 0.3f;
        this.shadowStrength = 0.75f;
    }

    public CollectibleEntityRenderState createRenderState() {
        return new CollectibleEntityRenderState();
    }

    public void extractRenderState(CollectibleEntity entity, CollectibleEntityRenderState state, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTick);
        ItemStack displayedItem = entity.getDisplayedItem();
        this.itemModeResolver.updateForNonLiving(state.displayedItemState, displayedItem, DISPLAY_CONTEXT, (Entity)entity);
    }

    public void render(CollectibleEntityRenderState state, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (state.displayedItemState.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        AABB boundingBox = state.displayedItemState.getModelBoundingBox();
        float offset = 0.0625f - (float)boundingBox.minY;
        float bob = (Mth.sin((float)(state.ageInTicks / 10.0f)) + 1.0f) * 0.05f;
        poseStack.translate(0.0f, bob + offset, 0.0f);
        poseStack.mulPose((Quaternionfc)Mth.rotationAroundAxis((Vector3f)Mth.Y_AXIS, (Quaternionf)this.entityRenderDispatcher.cameraOrientation(), (Quaternionf)new Quaternionf()));
        poseStack.scale(2.0f, 2.0f, 2.0f);
        state.displayedItemState.render(poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((EntityRenderState)state, poseStack, bufferSource, packedLight);
    }

    protected boolean shouldShowName(CollectibleEntity entity, double distanceToCameraSq) {
        return entity.hasCustomName() || entity.shouldShowName() && CollectibleEntityRenderer.isEntityPicked(entity);
    }

    private static boolean isEntityPicked(Entity entity) {
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            return entityHitResult.getEntity() == entity;
        }
        return false;
    }
}

