/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.entity;

import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.client.entity.model.ForkliftModel;
import com.lovetropics.extras.client.entity.state.ForkliftRenderState;
import com.lovetropics.extras.entity.ForkliftEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionfc;

public class ForkliftRenderer
extends EntityRenderer<ForkliftEntity, ForkliftRenderState> {
    private static final ResourceLocation TEXTURE = LTExtras.location("textures/entity/forklift.png");
    private static final RenderType LIGHTS = RenderType.eyes((ResourceLocation)LTExtras.location("textures/entity/forklift_lights.png"));
    private final ForkliftModel model;
    private static final boolean FORKLIFT_PICKUP_DEBUG = false;

    public ForkliftRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ForkliftModel(context.bakeLayer(ForkliftModel.LAYER_LOCATION));
    }

    public void extractRenderState(ForkliftEntity entity, ForkliftRenderState state, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTick);
        state.yRot = entity.getYRot(partialTick);
        state.wheelRot = entity.getWheelRot(partialTick);
        state.forkHeight = entity.getRenderForkHeight(partialTick);
        state.pickupAABB = entity.getPickupAABB();
    }

    public void render(ForkliftRenderState state, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render((EntityRenderState)state, poseStack, bufferSource, packedLight);
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.scale(2.4f, 2.4f, 2.4f);
        poseStack.translate(0.0f, -1.501f, 0.0f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(state.yRot));
        this.model.setupAnim(state);
        VertexConsumer builder = bufferSource.getBuffer(this.model.renderType(TEXTURE));
        this.model.renderToBuffer(poseStack, builder, packedLight, OverlayTexture.NO_OVERLAY);
        VertexConsumer builder2 = bufferSource.getBuffer(LIGHTS);
        this.model.renderToBuffer(poseStack, builder2, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    private static void renderHitbox(PoseStack posStack, VertexConsumer consumer, AABB hitbox) {
        ShapeRenderer.renderLineBox((PoseStack)posStack, (VertexConsumer)consumer, (double)hitbox.minX, (double)hitbox.minY, (double)hitbox.minZ, (double)hitbox.maxX, (double)hitbox.maxY, (double)hitbox.maxZ, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public ForkliftRenderState createRenderState() {
        return new ForkliftRenderState();
    }
}

