/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.entity;

import com.lovetropics.extras.client.entity.state.PartyBeamRenderState;
import com.lovetropics.extras.entity.vfx.PartyBeamEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EndCrystalModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EndCrystalRenderer;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EndCrystalRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class PartyBeamRenderer
extends EntityRenderer<PartyBeamEntity, PartyBeamRenderState> {
    private static final RenderType BEAM = RenderType.entitySmoothCutout((ResourceLocation)EnderDragonRenderer.CRYSTAL_BEAM_LOCATION);
    private static final ResourceLocation END_CRYSTAL_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/end_crystal/end_crystal.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)END_CRYSTAL_LOCATION);
    private final EndCrystalModel model;

    public PartyBeamRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
        this.model = new EndCrystalModel(context.bakeLayer(ModelLayers.END_CRYSTAL));
    }

    public void render(PartyBeamRenderState state, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(2.0f, 2.0f, 2.0f);
        poseStack.translate(0.0f, -0.5f, 0.0f);
        this.model.setupAnim((EndCrystalRenderState)state);
        this.model.renderToBuffer(poseStack, bufferSource.getBuffer(RENDER_TYPE), packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        Vec3 beamOffset = state.beamOffset;
        if (beamOffset != null) {
            float offsetY = EndCrystalRenderer.getY((float)state.ageInTicks);
            float deltaX = (float)beamOffset.x;
            float deltaY = (float)beamOffset.y;
            float deltaZ = (float)beamOffset.z;
            poseStack.translate(deltaX, deltaY, deltaZ);
            this.renderCrystalBeams(state.color, -deltaX, -deltaY + offsetY, -deltaZ, state.ageInTicks, poseStack, bufferSource, packedLight);
        }
        super.render((EntityRenderState)state, poseStack, bufferSource, packedLight);
    }

    public void renderCrystalBeams(int color, float deltaX, float deltaY, float deltaZ, float time, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float lengthXz = Mth.sqrt((float)(deltaX * deltaX + deltaZ * deltaZ));
        float length = Mth.sqrt((float)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
        poseStack.pushPose();
        poseStack.translate(0.0f, 2.0f, 0.0f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotation((float)(-Math.atan2(deltaZ, deltaX)) - 1.5707964f));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotation((float)(-Math.atan2(lengthXz, deltaY)) - 1.5707964f));
        VertexConsumer consumer = bufferSource.getBuffer(BEAM);
        float startTextureOffset = -time * 0.01f;
        float endTextureOffset = length / 32.0f - time * 0.01f;
        float lastX = 0.0f;
        float lastY = 0.75f;
        float lastProgress = 0.0f;
        PoseStack.Pose pose = poseStack.last();
        for (int i = 1; i <= 8; ++i) {
            float x = Mth.sin((float)((float)i * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float y = Mth.cos((float)((float)i * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float progress = (float)i / 8.0f;
            consumer.addVertex(pose, lastX * 0.2f, lastY * 0.2f, 0.0f).setColor(-16777216).setUv(lastProgress, startTextureOffset).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, -1.0f, 0.0f);
            consumer.addVertex(pose, lastX, lastY, length).setColor(color).setUv(lastProgress, endTextureOffset).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, -1.0f, 0.0f);
            consumer.addVertex(pose, x, y, length).setColor(color).setUv(progress, endTextureOffset).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, -1.0f, 0.0f);
            consumer.addVertex(pose, x * 0.2f, y * 0.2f, 0.0f).setColor(-16777216).setUv(progress, startTextureOffset).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, -1.0f, 0.0f);
            lastX = x;
            lastY = y;
            lastProgress = progress;
        }
        poseStack.popPose();
    }

    public PartyBeamRenderState createRenderState() {
        return new PartyBeamRenderState();
    }

    public void extractRenderState(PartyBeamEntity entity, PartyBeamRenderState state, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTick);
        state.ageInTicks = (float)entity.time + partialTick;
        state.showsBottom = entity.showsBottom();
        BlockPos target = entity.getBeamTarget();
        state.beamOffset = target != null ? Vec3.atCenterOf((Vec3i)target).subtract(entity.getPosition(partialTick)) : null;
        Vector3f color = entity.getColor();
        state.color = ARGB.colorFromFloat((float)1.0f, (float)color.x, (float)color.y, (float)color.z);
    }

    public boolean shouldRender(PartyBeamEntity entity, Frustum frustum, double cameraX, double cameraY, double cameraZ) {
        return super.shouldRender((Entity)entity, frustum, cameraX, cameraY, cameraZ) || entity.getBeamTarget() != null;
    }
}

