/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.entity;

import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.client.entity.model.SpinningSignModel;
import com.lovetropics.extras.client.entity.state.SpinningSignRenderState;
import com.lovetropics.extras.entity.SpinningSignEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Quaternionfc;

public class SpinningSignRenderer
extends EntityRenderer<SpinningSignEntity, SpinningSignRenderState> {
    private static final ResourceLocation TEXTURE = LTExtras.location("textures/entity/spinning_sign.png");
    private final SpinningSignModel model;
    private final ItemModelResolver itemModelResolver;

    public SpinningSignRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new SpinningSignModel(context.bakeLayer(SpinningSignModel.LAYER_LOCATION));
        this.itemModelResolver = context.getItemModelResolver();
    }

    public SpinningSignRenderState createRenderState() {
        return new SpinningSignRenderState();
    }

    public void render(SpinningSignRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.scale(0.3f, 0.3f, 0.3f);
        poseStack.scale(renderState.scale, renderState.scale, renderState.scale);
        poseStack.translate(0.0f, -0.5f, 0.0f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        this.model.setupAnim(renderState);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.yRot));
        VertexConsumer builder = bufferSource.getBuffer(this.model.renderType(TEXTURE));
        this.model.renderToBuffer(poseStack, builder, packedLight, OverlayTexture.NO_OVERLAY);
        if (renderState.text.isPresent()) {
            Component text = renderState.text.get();
            int width = Minecraft.getInstance().font.width((FormattedText)text);
            float scale = 0.18f;
            float y = -0.17f;
            if (width > 22) {
                int biggerThan = width - 22;
                scale = 0.18f - Mth.abs((float)((float)biggerThan * 0.004f));
                y = Mth.lerp((float)(scale / 0.18f), (float)0.35f, (float)y);
            }
            for (int i = 0; i < 4; ++i) {
                poseStack.pushPose();
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)i * 90.0f));
                poseStack.translate(0.0f, y, -5.01f);
                poseStack.scale(scale, scale, scale);
                Minecraft.getInstance().font.drawInBatch(text, -((float)width / 2.0f), 0.0f, -1, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, LightTexture.lightCoordsWithEmission((int)packedLight, (int)2));
                poseStack.popPose();
            }
        } else if (!renderState.itemStack.isEmpty()) {
            for (int i = 0; i < 4; ++i) {
                poseStack.pushPose();
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)i * 90.0f));
                poseStack.translate(0.0f, 0.5f, -5.01f);
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                renderState.itemStack.render(poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
                poseStack.popPose();
            }
        }
        poseStack.popPose();
    }

    public void extractRenderState(SpinningSignEntity entity, SpinningSignRenderState reusedState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)reusedState, partialTick);
        reusedState.scale = entity.getScale();
        reusedState.text = entity.getText();
        this.itemModelResolver.updateForNonLiving(reusedState.itemStack, entity.getItem(), ItemDisplayContext.FIXED, (Entity)entity);
    }
}

