/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.entity;

import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.client.entity.model.WaterCoolerModel;
import com.lovetropics.extras.client.entity.state.WaterCoolerRenderState;
import com.lovetropics.extras.entity.ForkliftEntity;
import com.lovetropics.extras.entity.WaterCoolerEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionfc;

public class WaterCoolerRenderer
extends EntityRenderer<WaterCoolerEntity, WaterCoolerRenderState> {
    private static final ResourceLocation TEXTURE = LTExtras.location("textures/entity/water_cooler.png");
    private final WaterCoolerModel<ForkliftEntity> model;

    public WaterCoolerRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new WaterCoolerModel(context.bakeLayer(WaterCoolerModel.LAYER_LOCATION));
    }

    public void extractRenderState(WaterCoolerEntity entity, WaterCoolerRenderState state, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTick);
        state.shake1AnimationState.copyFrom(entity.shake1AnimationState);
        state.shake2AnimationState.copyFrom(entity.shake2AnimationState);
        state.shake3AnimationState.copyFrom(entity.shake3AnimationState);
        state.shakeDispenseAnimationState.copyFrom(entity.shakeDispenseAnimationState);
        state.yRot = entity.getYRot(partialTick);
        state.shakeTime = entity.getShakeTime();
    }

    public void render(WaterCoolerRenderState state, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render((EntityRenderState)state, poseStack, bufferSource, packedLight);
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(0.0f, -1.28f, 0.0f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(state.yRot));
        this.model.setupAnim(state);
        VertexConsumer builder = bufferSource.getBuffer(this.model.renderType(TEXTURE));
        this.model.renderToBuffer(poseStack, builder, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    public WaterCoolerRenderState createRenderState() {
        return new WaterCoolerRenderState();
    }
}

