/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.entity.model;

import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.client.entity.animation.WaterCoolerAnimation;
import com.lovetropics.extras.client.entity.state.WaterCoolerRenderState;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.world.entity.Entity;

public class WaterCoolerModel<T extends Entity>
extends EntityModel<WaterCoolerRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(LTExtras.location("water_cooler"), "main");
    private final ModelPart root;
    private final ModelPart water_jug;
    private final KeyframeAnimation shake1Animation;
    private final KeyframeAnimation shake2Animation;
    private final KeyframeAnimation shake3Animation;
    private final KeyframeAnimation shakeDispenseAnimation;

    public WaterCoolerModel(ModelPart root) {
        super(root, RenderType::entityTranslucent);
        this.root = root.getChild("root");
        this.water_jug = this.root.getChild("water_jug");
        this.shake1Animation = WaterCoolerAnimation.SHAKE_1.bake(root);
        this.shake2Animation = WaterCoolerAnimation.SHAKE_2.bake(root);
        this.shake3Animation = WaterCoolerAnimation.SHAKE_3.bake(root);
        this.shakeDispenseAnimation = WaterCoolerAnimation.SHAKE_DISPENSE.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -18.0f, -7.0f, 10.0f, 18.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(32, 37).addBox(-3.0f, -19.0f, -5.0f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(38, 0).addBox(-5.0f, -18.0f, 2.0f, 10.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(32, 27).addBox(-5.0f, -9.0f, 2.0f, 10.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(38, 4).addBox(-4.0f, -10.0f, 2.0f, 8.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(38, 7).addBox(3.0f, -15.0f, 2.0f, 2.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(38, 14).addBox(-5.0f, -15.0f, 2.0f, 2.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(38, 21).addBox(-2.0f, -14.0f, 1.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(38, 24).addBox(1.0f, -14.0f, 1.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition water_jug = root.addOrReplaceChild("water_jug", CubeListBuilder.create().texOffs(0, 27).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 45).addBox(-3.0f, -7.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(8, 47).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-19.0f, (float)-2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(WaterCoolerRenderState state) {
        super.setupAnim((EntityRenderState)state);
        this.shake1Animation.apply(state.shake1AnimationState, state.ageInTicks);
        this.shake2Animation.apply(state.shake2AnimationState, state.ageInTicks);
        this.shake3Animation.apply(state.shake3AnimationState, state.ageInTicks);
        this.shakeDispenseAnimation.apply(state.shakeDispenseAnimationState, state.ageInTicks);
    }
}

