/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.item;

import com.lovetropics.extras.ExtraDataComponents;
import com.lovetropics.extras.item.CollectibleCompassItem;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.CompassAngle;
import net.minecraft.client.renderer.item.properties.numeric.CompassAngleState;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CollectibleCompassAngle
implements RangeSelectItemModelProperty {
    public static final MapCodec<CollectibleCompassAngle> MAP_CODEC = MapCodec.unit(CollectibleCompassAngle::new);
    private final CompassAngle missingDelegate = new CompassAngle(true, CompassAngleState.CompassTarget.NONE);
    private final CompassAngle recoveryDelegate = new CompassAngle(true, CompassAngleState.CompassTarget.RECOVERY);

    public float get(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CollectibleCompassItem.Target target = (CollectibleCompassItem.Target)stack.get(ExtraDataComponents.COLLECTIBLE_TARGET);
            if (target != null) {
                Optional lastDeathLocation = player.getLastDeathLocation();
                player.setLastDeathLocation(Optional.of(target.pos()));
                float angle = this.recoveryDelegate.get(stack, level, (LivingEntity)player, seed);
                player.setLastDeathLocation(lastDeathLocation);
                return angle;
            }
        }
        return this.missingDelegate.get(stack, level, entity, seed);
    }

    public MapCodec<CollectibleCompassAngle> type() {
        return MAP_CODEC;
    }
}

