/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.item;

import com.lovetropics.extras.block.entity.WordBoxBlockEntity;
import com.lovetropics.extras.client.block.WordBoxBlockEntityRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class WordBoxSpecialRenderer
implements SpecialModelRenderer<Component> {
    private final Font font;

    public WordBoxSpecialRenderer(Font font) {
        this.font = font;
    }

    public void render(@Nullable Component text, ItemDisplayContext context, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean hasFoilType) {
        WordBoxBlockEntityRenderer.renderText(poseStack, bufferSource, this.font, packedLight, Objects.requireNonNullElse(text, WordBoxBlockEntity.DEFAULT_TEXT));
    }

    public void getExtents(Set<Vector3f> vertices) {
    }

    @Nullable
    public Component extractArgument(ItemStack itemStack) {
        return (Component)itemStack.get(DataComponents.CUSTOM_NAME);
    }

    public record Unbaked() implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit(Unbaked::new);

        public SpecialModelRenderer<?> bake(EntityModelSet modelSet) {
            return new WordBoxSpecialRenderer(Minecraft.getInstance().font);
        }

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }
    }
}

