/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.particle;

import com.lovetropics.extras.client.particle.ExtraParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;

@EventBusSubscriber(modid="ltextras", value={Dist.CLIENT})
public class HoneyShortFallParticle {
    public static TextureSheetParticle createHoneyFallParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        ShortHoneyParticle dripparticle = new ShortHoneyParticle(level, x, y, z);
        dripparticle.gravity = 0.01f;
        dripparticle.lifetime = 8;
        dripparticle.setColor(0.582f, 0.448f, 0.082f);
        return dripparticle;
    }

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        Minecraft.getInstance().particleEngine.register((ParticleType)ExtraParticles.SHORT_HONEY_PARTICLE.get(), HoneyShortFallParticle::createHoneyFallParticle);
    }

    public static class ShortHoneyParticle
    extends DripParticle {
        public ShortHoneyParticle(ClientLevel level, double x, double y, double z) {
            super(level, x, y, z, (Fluid)Fluids.WATER);
        }

        protected void postMoveUpdate() {
            if (this.onGround) {
                this.remove();
                float f = Mth.randomBetween((RandomSource)this.random, (float)0.3f, (float)1.0f);
                if (this.random.nextFloat() < 0.05f) {
                    this.level.playLocalSound(this.x, this.y, this.z, SoundEvents.BEEHIVE_DRIP, SoundSource.BLOCKS, f, 1.0f, false);
                }
            }
        }
    }
}

