/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.screen;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.resolver.ResolvedServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerNameResolver;
import net.minecraft.network.Connection;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.status.ClientStatusPacketListener;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerboundStatusRequestPacket;

public class AutoJoinServerPinger {
    private static final Duration INTERVAL = Duration.ofSeconds(5L);
    private static final Duration TIMEOUT = Duration.ofSeconds(30L);
    private static final Executor EXECUTOR = Util.backgroundExecutor();
    private final ServerAddress address;
    @Nullable
    private CompletableFuture<Boolean> pendingPing;
    private Instant lastPingTime = Instant.now();

    public AutoJoinServerPinger(String address) {
        this.address = ServerAddress.parseString((String)address);
    }

    public boolean tick() {
        Duration timeSinceLastPing = Duration.between(this.lastPingTime, Instant.now());
        if (this.pendingPing != null) {
            return this.tickPendingPing(this.pendingPing, timeSinceLastPing);
        }
        if (timeSinceLastPing.compareTo(INTERVAL) > 0) {
            this.pendingPing = this.sendPing().handle((result, throwable) -> {
                if (throwable != null) {
                    return false;
                }
                return result;
            });
            this.lastPingTime = Instant.now();
        }
        return false;
    }

    private boolean tickPendingPing(CompletableFuture<Boolean> future, Duration timeSinceLastPing) {
        if (future.getNow(false).booleanValue()) {
            return true;
        }
        if (future.isDone()) {
            this.pendingPing = null;
            this.lastPingTime = Instant.now();
        } else if (timeSinceLastPing.compareTo(TIMEOUT) > 0) {
            this.pendingPing = null;
        }
        return false;
    }

    private CompletableFuture<Boolean> sendPing() {
        return CompletableFuture.supplyAsync(() -> ServerNameResolver.DEFAULT.resolveAddress(this.address).map(ResolvedServerAddress::asInetSocketAddress), EXECUTOR).thenComposeAsync(resolvedAddress -> {
            if (resolvedAddress.isEmpty()) {
                return CompletableFuture.completedFuture(false);
            }
            return this.doPing((InetSocketAddress)resolvedAddress.get());
        }, EXECUTOR);
    }

    private CompletableFuture<Boolean> doPing(InetSocketAddress resolvedAddress) {
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        final Connection connection = Connection.connectToServer((InetSocketAddress)resolvedAddress, (boolean)false, null);
        ClientStatusPacketListener listener = new ClientStatusPacketListener(){

            public void handleStatusResponse(ClientboundStatusResponsePacket packet) {
                future.complete(true);
                connection.disconnect((Component)Component.translatable((String)"multiplayer.status.finished"));
            }

            public void handlePongResponse(ClientboundPongResponsePacket packet) {
            }

            public void onDisconnect(DisconnectionDetails details) {
                future.complete(false);
            }

            public boolean isAcceptingMessages() {
                return connection.isConnected();
            }
        };
        connection.initiateServerboundStatusConnection(this.address.getHost(), this.address.getPort(), listener);
        connection.send((Packet)ServerboundStatusRequestPacket.INSTANCE);
        return future;
    }
}

