/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.screen;

import com.lovetropics.extras.ExtraLangKeys;
import com.lovetropics.extras.client.screen.AutoJoinServerPinger;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.FocusableTextWidget;
import net.minecraft.client.gui.components.LoadingDotsWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ServerClosedScreen
extends Screen {
    private static final Component TITLE = ExtraLangKeys.SERVER_CLOSED_TITLE.get();
    private static final Component QUIT = Component.translatable((String)"menu.quit");
    private final Type type;
    private final ServerData server;
    private final Component description;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    @Nullable
    private final AutoJoinServerPinger pinger;

    public ServerClosedScreen(Type type, DisconnectionDetails details, ServerData server) {
        super(TITLE);
        this.type = type;
        this.server = server;
        this.pinger = type.autoJoin ? new AutoJoinServerPinger(server.ip) : null;
        MutableComponent description = Component.empty();
        description.append(type.description.apply(details));
        if (type.autoJoin) {
            description.append("\n\n").append((Component)ExtraLangKeys.SERVER_CLOSED_AUTO_JOIN.get().withStyle(ChatFormatting.YELLOW));
        }
        this.description = description;
    }

    protected void init() {
        this.layout.addTitleHeader(TITLE, this.font);
        LinearLayout contents = ((LinearLayout)this.layout.addToContents((LayoutElement)LinearLayout.vertical())).spacing(10);
        contents.defaultCellSetting().alignHorizontallyCenter().alignVerticallyMiddle();
        int textWidth = 300;
        contents.addChild((LayoutElement)new FocusableTextWidget(textWidth, this.description, this.font));
        if (this.type.autoJoin) {
            contents.addChild((LayoutElement)new LoadingDotsWidget(this.font, CommonComponents.EMPTY));
        }
        contents.addChild((LayoutElement)SpacerElement.height((int)20));
        if (this.type == Type.CLIENT_RESTART) {
            contents.addChild((LayoutElement)Button.builder((Component)QUIT, b -> this.minecraft.stop()).build());
        } else {
            contents.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_TO_TITLE, b -> this.onClose()).build());
        }
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
    }

    public void tick() {
        if (this.pinger != null && this.pinger.tick()) {
            ServerAddress address = ServerAddress.parseString((String)this.server.ip);
            ConnectScreen.startConnecting((Screen)new TitleScreen(), (Minecraft)this.minecraft, (ServerAddress)address, (ServerData)this.server, (boolean)false, null);
        }
    }

    public Component getNarrationMessage() {
        return CommonComponents.joinForNarration((Component[])new Component[]{super.getNarrationMessage(), this.description});
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)new TitleScreen());
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public static enum Type {
        UNEXPECTED(true, details -> ExtraLangKeys.SERVER_CLOSED_UNEXPECTED.format(details.reason().copy().withStyle(ChatFormatting.GRAY))),
        SERVER_RESTART(true, details -> ExtraLangKeys.SERVER_CLOSED_RESTART.get()),
        CLIENT_RESTART(false, details -> ExtraLangKeys.SERVER_CLOSED_CLIENT_RESTART.get()),
        PERMANENT(false, details -> ExtraLangKeys.SERVER_CLOSED_PERMANENT.get());

        private final boolean autoJoin;
        private final Function<DisconnectionDetails, Component> description;

        private Type(boolean autoJoin, Function<DisconnectionDetails, Component> description) {
            this.autoJoin = autoJoin;
            this.description = description;
        }
    }
}

