/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.screen.container;

import com.lovetropics.extras.ExtraItems;
import com.lovetropics.extras.client.ClientCollectiblesList;
import com.lovetropics.extras.collectible.Collectible;
import com.lovetropics.extras.data.TropiCoinsStore;
import com.lovetropics.extras.data.attachment.ExtraAttachments;
import com.lovetropics.extras.item.CollectibleBasketItem;
import com.lovetropics.extras.network.message.ServerboundExchangeTropiCoinsPacket;
import com.lovetropics.extras.network.message.ServerboundPickCollectibleItemPacket;
import com.lovetropics.extras.network.message.ServerboundReturnCollectibleItemPacket;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class CollectibleBasketScreen
extends AbstractContainerScreen<Menu> {
    private static final Component TITLE = ((CollectibleBasketItem)((Object)ExtraItems.COLLECTIBLE_BASKET.get())).getName();
    private static final ResourceLocation BACKGROUND_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/creative_inventory/tab_items.png");
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/creative_inventory/scroller");
    private static final ResourceLocation TROPICOIN_SLOT_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"ltextras", (String)"currency_slot");
    private static final SimpleContainer TROPICOIN_CONTAINER = new SimpleContainer(1);
    private static final int BACKGROUND_WIDTH = 195;
    private static final int BACKGROUND_HEIGHT = 136;
    private static final int SLOT_SIZE = 18;
    private static final int COLUMNS = 9;
    private static final int ROWS = 5;
    private static final int SCROLL_BAR_X = 175;
    private static final int SCROLL_BAR_Y = 18;
    private static final int SCROLL_BAR_HEIGHT = 110;
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int TROPICOIN_SLOT_X = -24;
    private static final int TROPICOIN_SLOT_Y = 112;
    private float scroll;
    private boolean draggingScroller;
    private double dragOffsetY;
    @Nullable
    private Slot tropiCoinSlot;

    public CollectibleBasketScreen(Inventory playerInventory) {
        super((AbstractContainerMenu)new Menu(playerInventory.player, new CollectibleContainer(ClientCollectiblesList.get())), playerInventory, TITLE);
        playerInventory.player.containerMenu = this.menu;
        this.imageWidth = 195;
        this.imageHeight = 136;
    }

    protected void containerTick() {
        super.containerTick();
        ((Menu)this.menu).container.setScrollRowOffset(Math.round(this.clampScroll(this.scroll)));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
        ScreenRectangle scroller = this.scrollerRectangle();
        if (scroller != null) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, SCROLLER_SPRITE, scroller.left(), scroller.top(), scroller.width(), scroller.height());
        }
        if (this.tropiCoinSlot == null) {
            this.tropiCoinSlot = new Slot((Container)TROPICOIN_CONTAINER, 0, -24, 112);
            ((Menu)this.getMenu()).slots.add((Object)this.tropiCoinSlot);
        }
        if (this.tropiCoinSlot != null && Minecraft.getInstance().player != null && this.isHovering(this.tropiCoinSlot.x, this.tropiCoinSlot.y, 16, 16, mouseX, mouseY)) {
            graphics.setComponentTooltipForNextFrame(this.font, ExtraItems.TROPICOIN.asStack().getTooltipLines(Item.TooltipContext.of((Level)Minecraft.getInstance().level), (Player)Minecraft.getInstance().player, (TooltipFlag)TooltipFlag.NORMAL), mouseX, mouseY);
        }
    }

    protected void renderSlot(GuiGraphics graphics, Slot slot) {
        if (slot == this.tropiCoinSlot && Minecraft.getInstance().player != null) {
            TropiCoinsStore data = (TropiCoinsStore)Minecraft.getInstance().player.getData(ExtraAttachments.TROPICOINS_STORE);
            String text = data.getAmount() > 99 ? "99\u208a" : String.valueOf(data.getAmount());
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, TROPICOIN_SLOT_SPRITE, slot.x - 8, slot.y - 8, 32, 32);
            graphics.renderFakeItem(ExtraItems.TROPICOIN.asStack(), slot.x, slot.y);
            graphics.renderItemDecorations(this.font, ExtraItems.TROPICOIN.asStack(), slot.x, slot.y, text);
        }
        super.renderSlot(graphics, slot);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        ScreenRectangle scroller = this.scrollerRectangle();
        if (scroller != null && mouseX >= (double)scroller.left() && mouseX <= (double)scroller.right() && mouseY >= (double)scroller.top() && mouseY <= (double)scroller.bottom()) {
            this.draggingScroller = true;
            this.dragOffsetY = (double)scroller.top() - mouseY;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingScroller) {
            float targetScrollerY = (float)(mouseY + this.dragOffsetY) - 18.0f - (float)this.topPos;
            this.scroll = this.clampScroll(targetScrollerY / 95.0f * (float)this.maxScroll());
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        this.draggingScroller = false;
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.canScroll()) {
            this.scroll = this.clampScroll(this.scroll - (float)pScrollY);
            return true;
        }
        return false;
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND_LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, 195, 136, 256, 256, -1);
    }

    @Nullable
    private ScreenRectangle scrollerRectangle() {
        if (!this.canScroll()) {
            return null;
        }
        return new ScreenRectangle(this.leftPos + 175, this.topPos + 18 + this.scrollerY(), 12, 15);
    }

    private int scrollerY() {
        return Math.round(this.clampScroll(this.scroll) / (float)this.maxScroll() * 95.0f);
    }

    private float clampScroll(float scroll) {
        return Mth.clamp((float)scroll, (float)0.0f, (float)this.maxScroll());
    }

    private boolean canScroll() {
        return this.maxScroll() > 0;
    }

    private int maxScroll() {
        return Math.max(((Menu)this.menu).container.contentRows() - 5, 0);
    }

    protected void slotClicked(@Nullable Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot instanceof CollectibleSlot) {
            CollectibleSlot collectibleSlot = (CollectibleSlot)slot;
            switch (type) {
                case PICKUP: 
                case PICKUP_ALL: 
                case QUICK_MOVE: {
                    ItemStack carried = ((Menu)this.menu).getCarried();
                    if (carried.isEmpty()) {
                        this.tryPickCollectible(slot, collectibleSlot);
                        break;
                    }
                    this.tryReturnCollectible(carried);
                    break;
                }
            }
        } else if (slot == this.tropiCoinSlot) {
            TropiCoinsStore data = (TropiCoinsStore)Minecraft.getInstance().player.getData(ExtraAttachments.TROPICOINS_STORE);
            if (type == ClickType.PICKUP || type == ClickType.QUICK_CRAFT) {
                if (type == ClickType.QUICK_CRAFT) {
                    if (mouseButton == 5) {
                        mouseButton = 1;
                    } else if (mouseButton == 1) {
                        mouseButton = 0;
                    }
                }
                if (((Menu)this.getMenu()).getCarried().isEmpty()) {
                    if (data.getAmount() > 0) {
                        ItemStack stack = ExtraItems.TROPICOIN.asStack();
                        int maxStackSize = stack.getMaxStackSize();
                        int amount = 0;
                        if (mouseButton == 0) {
                            amount = Math.min(maxStackSize, data.getAmount());
                        } else if (mouseButton == 1) {
                            amount = Math.min(maxStackSize, data.getAmount()) / 2;
                        }
                        if (amount > 0) {
                            ((Menu)this.getMenu()).setCarried(stack.copyWithCount(amount));
                            data.setAmount(data.getAmount() - amount);
                            ClientPacketDistributor.sendToServer((CustomPacketPayload)new ServerboundExchangeTropiCoinsPacket(false, amount * 2), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                    }
                } else if (((Menu)this.getMenu()).getCarried().is(ExtraItems.TROPICOIN)) {
                    ItemStack stack = ((Menu)this.getMenu()).getCarried().copy();
                    int amount = 0;
                    if (mouseButton == 0) {
                        amount = stack.getCount();
                    } else if (mouseButton == 1) {
                        amount = 1;
                    }
                    if (amount > 0) {
                        stack.shrink(amount);
                        data.setAmount(data.getAmount() + amount);
                        ((Menu)this.getMenu()).setCarried(stack);
                        ClientPacketDistributor.sendToServer((CustomPacketPayload)new ServerboundExchangeTropiCoinsPacket(true, amount), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
            }
        } else {
            this.simulateInventorySlotClicked(slot, slotId, mouseButton, type);
        }
    }

    private void tryPickCollectible(Slot slot, CollectibleSlot collectibleSlot) {
        Holder<Collectible> collectible = collectibleSlot.getCollectible();
        if (collectible != null) {
            ((Menu)this.menu).setCarried(slot.getItem().copy());
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new ServerboundPickCollectibleItemPacket(collectible), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void tryReturnCollectible(ItemStack carried) {
        Holder<Collectible> carriedCollectible = Collectible.byItem(carried);
        if (carriedCollectible != null) {
            ((Menu)this.menu).setCarried(ItemStack.EMPTY);
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new ServerboundReturnCollectibleItemPacket(carriedCollectible), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simulateInventorySlotClicked(@Nullable Slot slot, int slotId, int mouseButton, ClickType type) {
        LocalPlayer player = this.minecraft.player;
        try {
            player.containerMenu = player.inventoryMenu;
            Slot mappedSlot = slot != null ? CollectibleBasketScreen.getSlotIn(slot, (AbstractContainerMenu)player.inventoryMenu) : null;
            int mappedSlotId = mappedSlot != null ? mappedSlot.index : slotId;
            this.minecraft.gameMode.handleInventoryMouseClick(player.inventoryMenu.containerId, mappedSlotId, mouseButton, type, (Player)player);
        }
        finally {
            player.containerMenu = this.menu;
        }
    }

    @Nullable
    private static Slot getSlotIn(Slot slot, AbstractContainerMenu menu) {
        for (Slot otherSlot : menu.slots) {
            if (!slot.isSameInventory(otherSlot) || slot.getContainerSlot() != otherSlot.getContainerSlot()) continue;
            return otherSlot;
        }
        return null;
    }

    public static class Menu
    extends AbstractContainerMenu {
        private final InventoryMenu inventoryMenu;
        private final CollectibleContainer container;

        protected Menu(Player player, CollectibleContainer container) {
            super(null, player.inventoryMenu.containerId);
            this.container = container;
            this.inventoryMenu = player.inventoryMenu;
            Inventory playerInventory = player.getInventory();
            for (int row = 0; row < 5; ++row) {
                for (int column = 0; column < 9; ++column) {
                    int index = column + row * 9;
                    this.addSlot(new CollectibleSlot(container, index, 9 + column * 18, 18 + row * 18));
                }
            }
            for (int column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)playerInventory, column, 9 + column * 18, 112));
            }
        }

        public ItemStack quickMoveStack(Player player, int pIndex) {
            return ItemStack.EMPTY;
        }

        public boolean stillValid(Player player) {
            return player.isHolding((Item)ExtraItems.COLLECTIBLE_BASKET.get());
        }

        public ItemStack getCarried() {
            return this.inventoryMenu.getCarried();
        }

        public void setCarried(ItemStack stack) {
            this.inventoryMenu.setCarried(stack);
        }
    }

    public static class CollectibleContainer
    implements Container {
        private final ClientCollectiblesList list;
        private int scrollRowOffset;

        public CollectibleContainer(ClientCollectiblesList list) {
            this.list = list;
        }

        public void setScrollRowOffset(int scrollRowOffset) {
            this.scrollRowOffset = scrollRowOffset;
        }

        public int getContainerSize() {
            return 45;
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Nullable
        public Holder<Collectible> getCollectible(int slot) {
            List<Holder<Collectible>> collectibles = this.list.collectibles();
            int index = this.getIndexForSlot(slot);
            if (index >= 0 && index < collectibles.size()) {
                return collectibles.get(index);
            }
            return null;
        }

        public ItemStack getItem(int slot) {
            List<ItemStack> stacks = this.list.itemStacks();
            int index = this.getIndexForSlot(slot);
            if (index >= 0 && index < stacks.size()) {
                return stacks.get(index);
            }
            return ItemStack.EMPTY;
        }

        public ItemStack removeItem(int slot, int amount) {
            return this.getItem(slot).copy();
        }

        public ItemStack removeItemNoUpdate(int slot) {
            return this.getItem(slot).copy();
        }

        public void setItem(int slot, ItemStack stack) {
        }

        public void setChanged() {
        }

        public boolean stillValid(Player player) {
            return true;
        }

        public void clearContent() {
        }

        public int contentRows() {
            return Mth.positiveCeilDiv((int)this.list.collectibles().size(), (int)9);
        }

        private int getIndexForSlot(int slot) {
            return slot + this.scrollRowOffset * 9;
        }
    }

    private static class CollectibleSlot
    extends Slot {
        private final CollectibleContainer container;

        public CollectibleSlot(CollectibleContainer container, int index, int x, int y) {
            super((Container)container, index, x, y);
            this.container = container;
        }

        public int getMaxStackSize() {
            return 1;
        }

        @Nullable
        public Holder<Collectible> getCollectible() {
            return this.container.getCollectible(this.index);
        }
    }
}

