/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.screen.menu;

import com.lovetropics.extras.ExtraLangKeys;
import com.lovetropics.extras.ExtrasConfig;
import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.client.screen.CustomSpritesButton;
import com.lovetropics.extras.mixin.client.AbstractWidgetAccess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="ltextras", value={Dist.CLIENT})
public class CustomTitleScreen {
    private static final Component SINGLEPLAYER_TEXT = Component.translatable((String)"menu.singleplayer");
    private static final Component MULTIPLAYER_TEXT = Component.translatable((String)"menu.multiplayer");
    private static final Component REALMS_TEXT = Component.translatable((String)"menu.online");
    private static final Component MODS_TEXT = Component.translatable((String)"fml.menu.mods");
    private static final Component OPTIONS_TEXT = Component.translatable((String)"menu.options");
    private static final Component QUIT_TEXT = Component.translatable((String)"menu.quit");
    private static final Component ACCESSIBILITY_TEXT = Component.translatable((String)"options.accessibility");
    private static final Component LANGUAGE_TEXT = Component.translatable((String)"options.language");
    private static final Component CREATE_TEST_WORLD_TEXT = Component.literal((String)"Create Test World");
    private static final WidgetSprites CONNECT_SPRITES = new WidgetSprites(LTExtras.location("widget/connect"), LTExtras.location("widget/connect_disabled"), LTExtras.location("widget/connect_highlighted"));

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Button singleplayer = CustomTitleScreen.findButton(event, SINGLEPLAYER_TEXT);
        Button multiplayer = CustomTitleScreen.findButton(event, MULTIPLAYER_TEXT);
        Button realms = CustomTitleScreen.findButton(event, REALMS_TEXT);
        Button mods = CustomTitleScreen.findButton(event, MODS_TEXT);
        Button options = CustomTitleScreen.findButton(event, OPTIONS_TEXT);
        Button quit = CustomTitleScreen.findButton(event, QUIT_TEXT);
        Button accessibility = CustomTitleScreen.findButton(event, ACCESSIBILITY_TEXT);
        Button language = CustomTitleScreen.findButton(event, LANGUAGE_TEXT);
        if (singleplayer == null || multiplayer == null || realms == null || mods == null || options == null || quit == null || accessibility == null || language == null) {
            return;
        }
        event.removeListener((GuiEventListener)realms);
        event.removeListener((GuiEventListener)mods);
        Button createTestWorldButton = CustomTitleScreen.findButton(event, CREATE_TEST_WORLD_TEXT);
        if (createTestWorldButton != null) {
            event.removeListener((GuiEventListener)createTestWorldButton);
        }
        CustomSpritesButton connectButton = new CustomSpritesButton(CONNECT_SPRITES, Button.builder((Component)ExtraLangKeys.MENU_CONNECT.get(), button -> CustomTitleScreen.connectToEvent(event.getScreen())).pos(singleplayer.getX(), singleplayer.getY()).width(singleplayer.getWidth()));
        connectButton.active = multiplayer.active;
        connectButton.setTooltip(((AbstractWidgetAccess)multiplayer).getTooltip().get());
        event.addListener((GuiEventListener)connectButton);
        event.addListener((GuiEventListener)Button.builder((Component)ExtraLangKeys.MENU_DONATE.get(), (Button.OnPress)ConfirmLinkScreen.confirmLink((Screen)event.getScreen(), (String)((String)ExtrasConfig.DONATE_URL.get()), (boolean)true)).pos(multiplayer.getX(), multiplayer.getY()).width(multiplayer.getWidth()).build());
        singleplayer.setPosition(options.getX(), mods.getY() + 5);
        singleplayer.setWidth(options.getWidth());
        multiplayer.setPosition(quit.getX(), singleplayer.getY());
        multiplayer.setWidth(quit.getWidth());
        int bottomRowY = singleplayer.getY() + singleplayer.getHeight() + 4;
        options.setY(bottomRowY);
        quit.setY(bottomRowY);
        int sideButtonY = (singleplayer.getY() + bottomRowY) / 2;
        language.setY(sideButtonY);
        accessibility.setY(sideButtonY);
    }

    private static void connectToEvent(Screen parentScreen) {
        ServerAddress address = ServerAddress.parseString((String)((String)ExtrasConfig.SERVER_ADDRESS.get()));
        ServerData serverData = new ServerData("Love Tropics", address.toString(), ServerData.Type.OTHER);
        ConnectScreen.startConnecting((Screen)parentScreen, (Minecraft)Minecraft.getInstance(), (ServerAddress)address, (ServerData)serverData, (boolean)false, null);
    }

    @Nullable
    private static Button findButton(ScreenEvent.Init.Post event, Component label) {
        return event.getListenersList().stream().filter(widget -> {
            Button button;
            return widget instanceof Button && (button = (Button)widget).getMessage().equals((Object)label);
        }).findFirst().orElse(null);
    }
}

