/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.collectible;

import com.lovetropics.extras.collectible.CollectibleRarity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record CollectibleDisplayInfo(String name, boolean description, CollectibleRarity rarity, Optional<List<Component>> additionalLore) {
    public static final Codec<CollectibleDisplayInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(CollectibleDisplayInfo::name), (App)Codec.BOOL.optionalFieldOf("description", (Object)false).forGetter(CollectibleDisplayInfo::description), (App)CollectibleRarity.CODEC.fieldOf("rarity").forGetter(CollectibleDisplayInfo::rarity), (App)ComponentSerialization.CODEC.listOf().optionalFieldOf("additional_lore").forGetter(CollectibleDisplayInfo::additionalLore)).apply((Applicative)instance, CollectibleDisplayInfo::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CollectibleDisplayInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, CollectibleDisplayInfo::name, (StreamCodec)ByteBufCodecs.BOOL, CollectibleDisplayInfo::description, CollectibleRarity.STREAM_CODEC, CollectibleDisplayInfo::rarity, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ComponentSerialization.STREAM_CODEC.apply(ByteBufCodecs.list())), CollectibleDisplayInfo::additionalLore, CollectibleDisplayInfo::new);

    public List<Component> getLore() {
        ArrayList<Component> lore = new ArrayList<Component>();
        if (this.description) {
            lore.add((Component)Component.translatable((String)("lt.collectible." + this.name + ".description")).withStyle(ChatFormatting.GRAY));
        }
        lore.add((Component)Component.empty());
        lore.add((Component)Component.translatable((String)("lt.collectible.unicode." + this.rarity.name().toLowerCase())));
        this.additionalLore.ifPresent(add -> {
            lore.add((Component)Component.empty());
            lore.addAll((Collection<Component>)add);
        });
        return lore;
    }

    public MutableComponent getComponent(ItemStack stack) {
        return Component.translatable((String)("lt.collectible." + this.name + ".name")).withStyle(style -> style.withColor((TextColor)TextColor.parseColor((String)this.rarity.getColor()).getOrThrow()));
    }
}

