/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.collectible;

import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;

public enum CollectibleExtraDisplayType implements StringRepresentable
{
    NONE((Component)Component.empty(), type -> List.of()),
    HAT((Component)Component.translatable((String)"lt.collectible.disguise.hat.suffix"), type -> List.of(Component.literal((String)" +").append(type.getDescription()).withStyle(ChatFormatting.BLUE))),
    DISGUISE((Component)Component.translatable((String)"lt.collectible.disguise.name.suffix"), type -> List.of(Component.translatable((String)"lt.collectible.disguise.tooltip.subtract_player"), Component.literal((String)" +").append(type.getDescription()).withStyle(ChatFormatting.BLUE)));

    private final Component component;
    private final Function<EntityType<?>, List<Component>> builder;

    private CollectibleExtraDisplayType(Component component, Function<EntityType<?>, List<Component>> builder) {
        this.component = component;
        this.builder = builder;
    }

    public Component getComponent() {
        return this.component;
    }

    public List<Component> getAdditionalLore(EntityType<?> type) {
        return this.builder.apply(type);
    }

    public String getSerializedName() {
        return this.name().toLowerCase();
    }
}

