/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.collectible;

import com.lovetropics.extras.collectible.Collectible;
import com.lovetropics.extras.collectible.CollectibleData;
import com.lovetropics.extras.collectible.CollectibleStore;
import com.lovetropics.extras.data.attachment.ExtraAttachments;
import com.lovetropics.extras.mixin.MinecraftServerAccessor;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.PlayerDataStorage;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class CollectibleLister {
    private static final String PLAYER_DATA_SUFFIX = ".dat";
    private static final Logger LOGGER = LogUtils.getLogger();

    public static CompletableFuture<List<UUID>> listPlayersWithItem(MinecraftServer server, Predicate<Holder<Collectible>> predicate) {
        return CollectibleLister.list(server).thenApplyAsync(entries -> {
            ArrayList<UUID> profileIds = new ArrayList<UUID>();
            for (Entry entry : entries) {
                for (Holder<Collectible> collectible : entry.data().collectibles()) {
                    if (!predicate.test(collectible)) continue;
                    profileIds.add(entry.profileId());
                }
            }
            return profileIds;
        }, (Executor)Util.backgroundExecutor());
    }

    public static CompletableFuture<List<Entry>> list(MinecraftServer server) {
        ObjectOpenHashSet seenProfileIds = new ObjectOpenHashSet();
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            CollectibleStore store = CollectibleStore.get((Player)player);
            entries.add(new Entry(player.getUUID(), store.asData()));
            seenProfileIds.add(player.getUUID());
        }
        PlayerDataStorage playerDataStorage = ((MinecraftServerAccessor)server).getPlayerDataStorage();
        RegistryOps ops = server.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> CollectibleLister.listSeenPlayers(playerDataStorage), (Executor)Util.ioPool()).thenCompose(arg_0 -> CollectibleLister.lambda$list$3((Set)seenProfileIds, playerDataStorage, ops, arg_0))).thenApply(loadedEntries -> {
            for (Entry entry : loadedEntries) {
                if (entry == null) continue;
                entries.add(entry);
            }
            return entries;
        });
    }

    private static List<UUID> listSeenPlayers(PlayerDataStorage storage) {
        List<UUID> list;
        block8: {
            Stream<Path> files = Files.list(storage.getPlayerDir().toPath());
            try {
                list = files.mapMulti((path, consumer) -> {
                    String fileName = path.getFileName().toString();
                    if (fileName.endsWith(PLAYER_DATA_SUFFIX)) {
                        String uuidString = fileName.substring(0, fileName.length() - PLAYER_DATA_SUFFIX.length());
                        try {
                            UUID uuid = UUID.fromString(uuidString);
                            consumer.accept(uuid);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }).toList();
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to list players with data", (Throwable)e);
                    return List.of();
                }
            }
            files.close();
        }
        return list;
    }

    @Nullable
    private static Entry loadPlayerData(UUID profileId, PlayerDataStorage playerDataStorage, RegistryOps<Tag> ops) {
        CompoundTag tag;
        try {
            Path path = playerDataStorage.getPlayerDir().toPath().resolve(String.valueOf(profileId) + PLAYER_DATA_SUFFIX);
            tag = NbtIo.readCompressed((Path)path, (NbtAccounter)NbtAccounter.unlimitedHeap());
        }
        catch (IOException e) {
            LOGGER.error("Failed to load player data for {}", (Object)profileId, (Object)e);
            return null;
        }
        CompoundTag attachmentsTag = tag.getCompoundOrEmpty("neoforge:attachments");
        Tag collectiblesTag = attachmentsTag.get(ExtraAttachments.COLLECTIBLE_STORE.getKey().location().toString());
        if (collectiblesTag == null) {
            return null;
        }
        return CollectibleData.MAP_CODEC.codec().parse(ops, (Object)collectiblesTag).resultOrPartial(Util.prefix((String)("Failed to parse player data for " + String.valueOf(profileId)), arg_0 -> ((Logger)LOGGER).warn(arg_0))).map(data -> new Entry(profileId, (CollectibleData)data)).orElse(null);
    }

    private static /* synthetic */ CompletionStage lambda$list$3(Set seenProfileIds, PlayerDataStorage playerDataStorage, RegistryOps ops, List seenPlayers) {
        ArrayList<CompletableFuture<Entry>> futures = new ArrayList<CompletableFuture<Entry>>();
        for (UUID profileId : seenPlayers) {
            if (seenProfileIds.contains(profileId)) continue;
            futures.add(CompletableFuture.supplyAsync(() -> CollectibleLister.loadPlayerData(profileId, playerDataStorage, (RegistryOps<Tag>)ops), (Executor)Util.ioPool()));
        }
        return Util.sequence(futures);
    }

    public record Entry(UUID profileId, CollectibleData data) {
    }
}

