/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.collectible;

import com.mojang.serialization.Codec;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum CollectibleRarity implements StringRepresentable
{
    PURCHASED("#BFEA00"),
    REWARD("#005958"),
    SECRET("#5ABDA3"),
    MILESTONE("#005958"),
    QUEST("#E5B106");

    public static final Codec<CollectibleRarity> CODEC;
    public static final StreamCodec<FriendlyByteBuf, CollectibleRarity> STREAM_CODEC;
    private final String color;

    private CollectibleRarity(String color) {
        this.color = color;
    }

    public String getColor() {
        return this.color;
    }

    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    static {
        CODEC = StringRepresentable.fromEnum(CollectibleRarity::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(CollectibleRarity.class);
    }
}

