/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.collectible;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.lovetropics.extras.ExtraDataComponents;
import com.lovetropics.extras.collectible.Collectible;
import com.lovetropics.extras.collectible.CollectibleDisplayInfo;
import com.lovetropics.extras.collectible.CollectibleExtraDisplayType;
import com.lovetropics.extras.collectible.CollectibleRarity;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.equipment.Equippable;
import net.neoforged.neoforge.server.command.EnumArgument;

public class GenerateCollectibleCommand {
    private static final SimpleCommandExceptionType ALREADY_CREATED = new SimpleCommandExceptionType((Message)Component.literal((String)"Collectible data already created please use /generatecollectible modify"));
    private static final SimpleCommandExceptionType NOT_CREATED = new SimpleCommandExceptionType((Message)Component.literal((String)"Collectible data not found on held item. Please use \"/generatecollectible create\" first."));
    private static final SimpleCommandExceptionType NOT_A_COLLECTIBLE = new SimpleCommandExceptionType((Message)Component.literal((String)"The held item is not a collectible."));
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"generatecollectible").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"create").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"rarity", (ArgumentType)EnumArgument.enumArgument(CollectibleRarity.class)).executes(context -> GenerateCollectibleCommand.create((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"name"), (CollectibleRarity)((Object)((Object)context.getArgument("rarity", CollectibleRarity.class))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"modify").then(Commands.literal((String)"rarity").then(Commands.argument((String)"rarity", (ArgumentType)EnumArgument.enumArgument(CollectibleRarity.class)).executes(context -> GenerateCollectibleCommand.setRarity((CommandContext<CommandSourceStack>)context, (CollectibleRarity)((Object)((Object)context.getArgument("rarity", CollectibleRarity.class)))))))).then(Commands.literal((String)"description").then(Commands.argument((String)"description", (ArgumentType)BoolArgumentType.bool()).executes(context -> GenerateCollectibleCommand.setDescription((CommandContext<CommandSourceStack>)context, (Boolean)context.getArgument("description", Boolean.class)))))).then(Commands.literal((String)"extra_lore").then(Commands.argument((String)"extra_lore", (ArgumentType)ComponentArgument.textComponent((CommandBuildContext)buildContext)).executes(context -> GenerateCollectibleCommand.setExtraLore((CommandContext<CommandSourceStack>)context, ComponentArgument.getResolvedComponent((CommandContext)context, (String)"extra_lore")))))).then(Commands.literal((String)"name").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(context -> GenerateCollectibleCommand.setName((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"extra_lore"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"special").then(Commands.literal((String)"entity_named").then(Commands.argument((String)"entity", (ArgumentType)ResourceArgument.resource((CommandBuildContext)buildContext, (ResourceKey)Registries.ENTITY_TYPE)).then(Commands.argument((String)"type", (ArgumentType)EnumArgument.enumArgument(CollectibleExtraDisplayType.class)).executes(context -> GenerateCollectibleCommand.setSpecialName((CommandContext<CommandSourceStack>)context, ResourceArgument.getResource((CommandContext)context, (String)"entity", (ResourceKey)Registries.ENTITY_TYPE), (CollectibleExtraDisplayType)((Object)((Object)context.getArgument("type", CollectibleExtraDisplayType.class))))))))).then(Commands.literal((String)"hide_components").then(Commands.argument((String)"components", (ArgumentType)ResourceOrTagArgument.resourceOrTag((CommandBuildContext)buildContext, (ResourceKey)Registries.DATA_COMPONENT_TYPE)).executes(context -> GenerateCollectibleCommand.hideComponents((CommandContext<CommandSourceStack>)context, ResourceOrTagArgument.getResourceOrTag((CommandContext)context, (String)"components", (ResourceKey)Registries.DATA_COMPONENT_TYPE)))))).then(Commands.literal((String)"remove_components").then(Commands.argument((String)"components", (ArgumentType)ResourceOrTagArgument.resourceOrTag((CommandBuildContext)buildContext, (ResourceKey)Registries.DATA_COMPONENT_TYPE)).executes(context -> GenerateCollectibleCommand.removeComponents((CommandContext<CommandSourceStack>)context, ResourceOrTagArgument.getResourceOrTag((CommandContext)context, (String)"components", (ResourceKey)Registries.DATA_COMPONENT_TYPE))))))).then(Commands.literal((String)"export").executes(GenerateCollectibleCommand::export)));
    }

    private static int export(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        ItemStack heldItem = player.getMainHandItem();
        CollectibleDisplayInfo collectibleLore = (CollectibleDisplayInfo)heldItem.get(ExtraDataComponents.COLLECTIBLE_LORE);
        if (collectibleLore == null) {
            throw NOT_A_COLLECTIBLE.create();
        }
        Collectible collectible = new Collectible(heldItem);
        String json = GSON.toJson((JsonElement)Collectible.DIRECT_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)collectible).getOrThrow());
        ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Exported Click to Copy").withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.CopyToClipboard(json))));
        return 1;
    }

    private static int create(CommandContext<CommandSourceStack> ctx, String name, CollectibleRarity rarity) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        ItemStack heldItem = player.getMainHandItem();
        CollectibleDisplayInfo collectibleLore = (CollectibleDisplayInfo)heldItem.get(ExtraDataComponents.COLLECTIBLE_LORE);
        if (collectibleLore == null) {
            CollectibleDisplayInfo newLore = new CollectibleDisplayInfo(name, false, rarity, Optional.empty());
            heldItem.set(ExtraDataComponents.COLLECTIBLE_LORE, (Object)newLore);
            heldItem.set(DataComponents.CUSTOM_NAME, (Object)newLore.getComponent(heldItem));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Initialized Collectable " + name + " with rarity " + String.valueOf((Object)rarity))), false);
            return 1;
        }
        throw ALREADY_CREATED.create();
    }

    private static int setName(CommandContext<CommandSourceStack> ctx, String name) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        ItemStack heldItem = player.getMainHandItem();
        CollectibleDisplayInfo collectibleLore = (CollectibleDisplayInfo)heldItem.get(ExtraDataComponents.COLLECTIBLE_LORE);
        if (collectibleLore != null) {
            CollectibleDisplayInfo newLore = new CollectibleDisplayInfo(name, collectibleLore.description(), collectibleLore.rarity(), collectibleLore.additionalLore());
            heldItem.set(ExtraDataComponents.COLLECTIBLE_LORE, (Object)newLore);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Set collectible description to " + name + " on held item.")), false);
            return 1;
        }
        throw NOT_CREATED.create();
    }

    private static int setExtraLore(CommandContext<CommandSourceStack> ctx, Component component) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        ItemStack heldItem = player.getMainHandItem();
        CollectibleDisplayInfo collectibleLore = (CollectibleDisplayInfo)heldItem.get(ExtraDataComponents.COLLECTIBLE_LORE);
        if (collectibleLore != null) {
            CollectibleDisplayInfo newLore = new CollectibleDisplayInfo(collectibleLore.name(), collectibleLore.description(), collectibleLore.rarity(), Optional.of(List.of(component)));
            heldItem.set(ExtraDataComponents.COLLECTIBLE_LORE, (Object)newLore);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Set collectible description to  on held item."), false);
            return 1;
        }
        throw NOT_CREATED.create();
    }

    private static int setDescription(CommandContext<CommandSourceStack> ctx, boolean description) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        ItemStack heldItem = player.getMainHandItem();
        CollectibleDisplayInfo collectibleLore = (CollectibleDisplayInfo)heldItem.get(ExtraDataComponents.COLLECTIBLE_LORE);
        if (collectibleLore != null) {
            CollectibleDisplayInfo newLore = new CollectibleDisplayInfo(collectibleLore.name(), description, collectibleLore.rarity(), collectibleLore.additionalLore());
            heldItem.set(ExtraDataComponents.COLLECTIBLE_LORE, (Object)newLore);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Set collectible description to " + description + " on held item.")), false);
            return 1;
        }
        throw NOT_CREATED.create();
    }

    private static int setRarity(CommandContext<CommandSourceStack> ctx, CollectibleRarity rarity) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        ItemStack heldItem = player.getMainHandItem();
        CollectibleDisplayInfo collectibleLore = (CollectibleDisplayInfo)heldItem.get(ExtraDataComponents.COLLECTIBLE_LORE);
        if (collectibleLore != null) {
            CollectibleDisplayInfo newLore = new CollectibleDisplayInfo(collectibleLore.name(), collectibleLore.description(), rarity, collectibleLore.additionalLore());
            heldItem.set(ExtraDataComponents.COLLECTIBLE_LORE, (Object)newLore);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Set collectible rarity to " + rarity.name() + " on held item.")), false);
            return 1;
        }
        throw NOT_CREATED.create();
    }

    private static int setSpecialName(CommandContext<CommandSourceStack> context, Holder.Reference<EntityType<?>> entity, CollectibleExtraDisplayType type) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ItemStack heldItem = player.getMainHandItem();
        CollectibleDisplayInfo collectibleLore = (CollectibleDisplayInfo)heldItem.get(ExtraDataComponents.COLLECTIBLE_LORE);
        if (collectibleLore != null) {
            EntityType value = (EntityType)entity.value();
            MutableComponent append = Component.empty().append(value.getDescription()).append(" ").append(type.getComponent()).withStyle(style -> style.withItalic(Boolean.valueOf(false)).withColor((TextColor)TextColor.parseColor((String)collectibleLore.rarity().getColor()).getOrThrow()));
            heldItem.set(DataComponents.CUSTOM_NAME, (Object)append);
            Equippable equippable = (Equippable)heldItem.get(DataComponents.EQUIPPABLE);
            if (equippable != null) {
                ArrayList<Object> extraLore = new ArrayList<Object>();
                EquipmentSlot slot = equippable.slot();
                MutableComponent translatable = Component.translatable((String)("item.modifiers." + slot.getSerializedName()));
                extraLore.add(translatable.withStyle(ChatFormatting.GRAY));
                extraLore.addAll(type.getAdditionalLore(value));
                CollectibleDisplayInfo newLore = new CollectibleDisplayInfo(collectibleLore.name(), collectibleLore.description(), collectibleLore.rarity(), Optional.of(extraLore));
                heldItem.set(ExtraDataComponents.COLLECTIBLE_LORE, (Object)newLore);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Set special collectible name for entity " + value.getDescription().getString() + " on held item.")), false);
            }
            return 1;
        }
        throw NOT_CREATED.create();
    }

    private static int hideComponents(CommandContext<CommandSourceStack> context, ResourceOrTagArgument.Result<DataComponentType<?>> components) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ItemStack heldItem = player.getMainHandItem();
        ArrayList<DataComponentType> typesToHide = new ArrayList<DataComponentType>();
        for (Holder dataComponentType : BuiltInRegistries.DATA_COMPONENT_TYPE.asHolderIdMap()) {
            if (!components.test((Object)dataComponentType) || !heldItem.has((DataComponentType)dataComponentType.value())) continue;
            typesToHide.add((DataComponentType)dataComponentType.value());
        }
        TooltipDisplay tooltipDisplay = heldItem.has(DataComponents.TOOLTIP_DISPLAY) ? (TooltipDisplay)heldItem.get(DataComponents.TOOLTIP_DISPLAY) : TooltipDisplay.DEFAULT;
        for (DataComponentType dataComponentType : typesToHide) {
            tooltipDisplay = tooltipDisplay.withHidden(dataComponentType, true);
        }
        heldItem.set(DataComponents.TOOLTIP_DISPLAY, (Object)tooltipDisplay);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Hid specified data components on held item."), true);
        return 1;
    }

    private static int removeComponents(CommandContext<CommandSourceStack> context, ResourceOrTagArgument.Result<DataComponentType<?>> components) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ItemStack heldItem = player.getMainHandItem();
        for (Holder dataComponentType : BuiltInRegistries.DATA_COMPONENT_TYPE.asHolderIdMap()) {
            if (!components.test((Object)dataComponentType) || !heldItem.has((DataComponentType)dataComponentType.value())) continue;
            heldItem.remove((DataComponentType)dataComponentType.value());
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Removed specified data components on held item."), true);
        return 1;
    }
}

