/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class HandCommand {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"hand").requires(source -> source.hasPermission(4))).then(Commands.literal((String)"json").executes(HandCommand::json))).then(Commands.literal((String)"nbt").executes(HandCommand::displayItem)));
    }

    private static int json(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        ItemStack heldItem = player.getMainHandItem();
        RegistryOps registryops = player.getServer().registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        String json = GSON.toJson((JsonElement)ItemStack.CODEC.encodeStart((DynamicOps)registryops, (Object)heldItem).getOrThrow());
        ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Exported Click to Copy").withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.CopyToClipboard(json))));
        return 1;
    }

    private static int displayItem(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        ItemStack mainHandItem = player.getMainHandItem();
        String serialize = new ItemInput(mainHandItem.getItemHolder(), mainHandItem.getComponentsPatch()).serialize((HolderLookup.Provider)player.getServer().registryAccess());
        ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Exported Click to Copy").withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.CopyToClipboard(serialize))));
        return 1;
    }
}

