/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;

public class ListScoreboardCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"listscoreboard").requires(source -> source.hasPermission(4))).then(((RequiredArgumentBuilder)Commands.argument((String)"objective", (ArgumentType)ObjectiveArgument.objective()).then(Commands.literal((String)"players").executes(ListScoreboardCommand::listPlayers))).then(Commands.literal((String)"scores").executes(ListScoreboardCommand::listScores))));
    }

    private static int listPlayers(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Objective objective = ObjectiveArgument.getObjective(ctx, (String)"objective");
        Scoreboard scoreboard = objective.getScoreboard();
        ArrayList<String> names = new ArrayList<String>();
        for (ScoreHolder trackedPlayer : scoreboard.getTrackedPlayers()) {
            ReadOnlyScoreInfo playerScoreInfo = scoreboard.getPlayerScoreInfo(trackedPlayer, objective);
            if (playerScoreInfo == null) continue;
            names.add(trackedPlayer.getScoreboardName());
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Players with score for ").append(objective.getDisplayName()).append(String.join((CharSequence)", ", names)), false);
        return 1;
    }

    private static int listScores(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Objective objective = ObjectiveArgument.getObjective(ctx, (String)"objective");
        Scoreboard scoreboard = objective.getScoreboard();
        MutableComponent header = Component.literal((String)"Scores for objective: ").append(objective.getDisplayName());
        for (ScoreHolder trackedPlayer : scoreboard.getTrackedPlayers()) {
            ReadOnlyScoreInfo playerScoreInfo = scoreboard.getPlayerScoreInfo(trackedPlayer, objective);
            if (playerScoreInfo == null) continue;
            int score = playerScoreInfo.value();
            MutableComponent scoreLine = Component.literal((String)trackedPlayer.getScoreboardName()).append(": ").append((Component)Component.literal((String)Integer.toString(score)));
            header.append((Component)Component.literal((String)"\n"));
            header.append((Component)scoreLine);
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> header, false);
        return 1;
    }
}

