/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.command;

import com.lovetropics.extras.data.Named;
import com.lovetropics.extras.data.poi.MapConfig;
import com.lovetropics.extras.data.poi.MapManager;
import com.lovetropics.extras.data.poi.PoiConfig;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;

public class WarpCommand {
    private static final String ARGUMENT_TARGET = "target";
    private static final SimpleCommandExceptionType NOT_FOUND = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.warp.not_found"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"warp").then(Commands.argument((String)ARGUMENT_TARGET, (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> {
            MapManager poiManager = MapManager.get(((CommandSourceStack)context.getSource()).getServer());
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            return SharedSuggestionProvider.suggestResource(poiManager.getAccessiblePois(player).map(ResourceKey::location), (SuggestionsBuilder)builder);
        }).executes(WarpCommand::warp)));
    }

    private static int warp(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ResourceLocation targetName = ResourceLocationArgument.getId(ctx, (String)ARGUMENT_TARGET);
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.getPlayerOrException();
        Named<PoiConfig> target = MapManager.get(source.getServer()).getPoiAccessibleTo(player, targetName);
        if (target == null) {
            throw NOT_FOUND.create();
        }
        BlockPos blockPos = target.value().pos();
        ServerLevel level = player.getServer().getLevel(((MapConfig)target.value().map().value()).dimension());
        if (level == null) {
            throw NOT_FOUND.create();
        }
        float yRot = target.value().angle().orElse(Float.valueOf(player.getYRot())).floatValue();
        player.teleportTo(level, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.0, (double)blockPos.getZ() + 0.5, Set.of(), yRot, player.getXRot(), true);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
        source.sendSuccess(() -> Component.translatable((String)"commands.warp.success", (Object[])new Object[]{((PoiConfig)target.value()).description()}), false);
        return 1;
    }

    public static void addTranslations(RegistrateLangProvider provider) {
        provider.add("commands.warp.success", "Warped to %s");
        provider.add("commands.warp.not_found", "Destination not found");
    }
}

