/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data;

import com.lovetropics.extras.ExtraBlocks;
import com.lovetropics.extras.LTExtras;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.data.ConnectingModelData;
import com.supermartijn642.fusion.api.model.data.ConnectingModelDataBuilder;
import com.supermartijn642.fusion.api.predicate.DefaultConnectionPredicates;
import com.supermartijn642.fusion.api.provider.FusionModelProvider;
import javax.annotation.Nullable;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="ltextras", value={Dist.CLIENT})
public class ExtraFusionModelProvider
extends FusionModelProvider {
    public ExtraFusionModelProvider(PackOutput output) {
        super("ltextras", output);
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent.Client event) {
        event.createProvider(ExtraFusionModelProvider::new);
    }

    protected void generate() {
        this.createConnectedPiecedModel((Block)ExtraBlocks.RED_SHIPPING_CONTAINER.get(), null);
        this.createConnectedPiecedModel((Block)ExtraBlocks.BLUE_SHIPPING_CONTAINER.get(), null);
        this.createConnectedPiecedModel((Block)ExtraBlocks.YELLOW_SHIPPING_CONTAINER.get(), null);
        this.createConnectedPiecedModel((Block)ExtraBlocks.GREEN_SHIPPING_CONTAINER.get(), null);
        this.createConnectedPiecedModel((Block)ExtraBlocks.WAREHOUSE_ROAD.get(), null);
        this.createGroundLayerModel((Block)ExtraBlocks.WAREHOUSE_PARKING_MARKING.get(), DefaultModelTypes.CONNECTING, null);
        this.createBaseModel((Block)ExtraBlocks.WAREHOUSE_FLOOR.get(), null, null);
    }

    protected void createConnectedPiecedModel(Block block, @Nullable String texId) {
        ResourceLocation texture = texId == null ? TextureMapping.getBlockTexture((Block)block) : LTExtras.location("block/" + texId);
        ConnectingModelData modelData = (ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelDataBuilder.builder().parent(ResourceLocation.withDefaultNamespace((String)"block/cube_all"))).texture("all", texture)).connection(DefaultConnectionPredicates.isSameBlock()).build();
        this.addModel(ModelLocationUtils.getModelLocation((Block)block), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)modelData));
    }

    protected void createBaseModel(Block block, @Nullable String texId, @Nullable ResourceLocation modelParent) {
        ResourceLocation texture = texId == null ? TextureMapping.getBlockTexture((Block)block) : LTExtras.location("block/" + texId);
        ConnectingModelData modelData = (ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelDataBuilder.builder().parent(modelParent == null ? ResourceLocation.withDefaultNamespace((String)"block/cube_all") : modelParent)).texture("all", texture)).connection(DefaultConnectionPredicates.isSameBlock()).build();
        this.addModel(ModelLocationUtils.getModelLocation((Block)block), ModelInstance.of((ModelType)DefaultModelTypes.BASE, (Object)modelData));
    }

    protected void createGroundLayerModel(Block block, @Nullable ModelType modelType, @Nullable String texId) {
        ResourceLocation texture = texId == null ? TextureMapping.getBlockTexture((Block)block) : LTExtras.location("block/" + texId);
        ConnectingModelData modelData = (ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelDataBuilder.builder().parent(LTExtras.location("block/ground_plane"))).texture("up", texture)).connection(DefaultConnectionPredicates.isSameBlock()).build();
        this.addModel(ModelLocationUtils.getModelLocation((Block)block), ModelInstance.of((ModelType)(modelType == null ? DefaultModelTypes.BASE : modelType), (Object)modelData));
    }
}

