/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data;

import com.lovetropics.extras.BlockFactory;
import com.lovetropics.extras.block.PapyrusUmbelBlock;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.generators.RegistrateBlockModelGenerator;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;

public final class ImposterBlockTemplate {
    public final BlockFactory<? extends Block> factory;
    public final Model model;

    public ImposterBlockTemplate(BlockFactory<? extends Block> factory, Model model) {
        this.factory = factory;
        this.model = model;
    }

    public static ImposterBlockTemplate simpleCube() {
        return ImposterBlockTemplate.cube(Block::new);
    }

    public static ImposterBlockTemplate halfTransparentCube() {
        return new ImposterBlockTemplate(HalfTransparentBlock::new, Model.HALF_TRANSPARENT_CUBE);
    }

    public static ImposterBlockTemplate cube(BlockFactory<? extends Block> factory) {
        return new ImposterBlockTemplate(factory, Model.CUBE);
    }

    public static ImposterBlockTemplate cross(BlockFactory<? extends Block> factory) {
        return new ImposterBlockTemplate(factory, Model.CROSS);
    }

    public static enum Model {
        CUBE,
        HALF_TRANSPARENT_CUBE,
        CROSS;


        public static void generatePapyrusUmbel(DataGenContext<Block, PapyrusUmbelBlock> ctx, RegistrateBlockModelGenerator prov) {
            prov.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)ctx.get())).with(PropertyDispatch.initial(PapyrusUmbelBlock.TYPE).generate(type -> {
                String typeName = type.getSerializedName();
                String modelName = typeName + "_" + ctx.getName();
                ResourceLocation texture = prov.modLoc("block/papyrus/" + modelName);
                ResourceLocation model = prov.getBuilder().transformTemplate(template -> {
                    template.parent(prov.mcLoc("block/sugar_cane"));
                    template.renderType(prov.mcLoc("cutout"));
                }).texture(TextureSlot.CROSS, texture).build(prov.modLoc("block/" + modelName));
                return BlockModelGenerators.plainVariant((ResourceLocation)model);
            })));
        }

        public BlockBuilder<? extends Block, Registrate> apply(BlockBuilder<? extends Block, Registrate> block, ResourceLocation id) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> block.blockstate(() -> (ctx, prov) -> prov.create((Block)ctx.getEntry(), id.withPrefix("block/"))).simpleItem();
                case 1 -> block.blockstate(() -> (ctx, prov) -> prov.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)ctx.get()), (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)id.withPrefix("block/"))))).addLayer(() -> () -> ChunkSectionLayer.TRANSLUCENT).simpleItem();
                case 2 -> {
                    ResourceLocation texture = id.withPrefix("block/");
                    yield (BlockBuilder)block.blockstate(() -> (ctx, prov) -> prov.createCrossBlock((Block)ctx.get(), BlockModelGenerators.PlantType.NOT_TINTED, TextureMapping.cross((ResourceLocation)texture))).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).item().model(() -> (ctx, prov) -> prov.generateFlatItem((Item)ctx.get(), texture)).build();
                }
            };
        }
    }
}

