/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.lovetropics.extras.data.Named;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public record SimpleDataPackLister<T>(String root, ResourceKey<Registry<T>> registryKey, Codec<T> codec) {
    private static final Logger LOGGER = LogUtils.getLogger();

    public FileToIdConverter fileToIdConverter() {
        return FileToIdConverter.json((String)this.root);
    }

    public CompletableFuture<List<Named<T>>> load(RegistryAccess registryAccess, ResourceManager resourceManager, Executor executor) {
        RegistryOps ops = registryAccess.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        return CompletableFuture.supplyAsync(() -> this.listEntries((DynamicOps<JsonElement>)ops, resourceManager, executor), executor).thenCompose(Function.identity());
    }

    private CompletableFuture<List<Named<T>>> listEntries(DynamicOps<JsonElement> ops, ResourceManager resourceManager, Executor executor) {
        FileToIdConverter lister = this.fileToIdConverter();
        List<CompletableFuture> futures = lister.listMatchingResources(resourceManager).entrySet().stream().map(resource -> {
            ResourceLocation path = (ResourceLocation)resource.getKey();
            ResourceLocation id = lister.fileToId(path);
            return CompletableFuture.supplyAsync(() -> {
                T entry = this.loadEntry(ops, path, (Resource)resource.getValue());
                return entry != null ? new Named<T>(ResourceKey.create(this.registryKey, (ResourceLocation)id), entry) : null;
            }, executor);
        }).toList();
        return Util.sequence(futures).thenApply(configs -> configs.stream().filter(Objects::nonNull).toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private T loadEntry(DynamicOps<JsonElement> ops, ResourceLocation path, Resource resource) {
        try (BufferedReader reader = resource.openAsReader();){
            T t = this.codec.parse(ops, (Object)JsonParser.parseReader((Reader)reader)).ifError(error -> LOGGER.error("Failed to load data pack entry at {}: {}", (Object)path, (Object)error.error())).resultOrPartial().orElse(null);
            return t;
        }
        catch (JsonParseException | IOException e) {
            LOGGER.error("Failed to load data pack entry at {}", (Object)path, (Object)e);
            return null;
        }
    }
}

