/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data.packcontrol;

import com.lovetropics.extras.network.message.ClientboundUpdatePackControl;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="ltextras")
public class PackControl
extends SavedData {
    private static final String STORAGE_ID = "ltextras_pack_control";
    public static final SavedDataType<PackControl> ID = new SavedDataType("ltextras_pack_control", PackControl::new, RecordCodecBuilder.create(instance -> instance.group((App)State.CODEC.fieldOf("state").forGetter(o -> o.state)).apply((Applicative)instance, PackControl::new)));
    private State state = State.DEFAULT;

    public static PackControl get(MinecraftServer server) {
        return (PackControl)server.overworld().getDataStorage().computeIfAbsent(ID);
    }

    private static PackControl load(CompoundTag tag, HolderLookup.Provider registries) {
        PackControl packControl = new PackControl();
        State.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("state")).ifSuccess(state -> {
            packControl.state = state;
        });
        return packControl;
    }

    public PackControl(State state) {
        this.state = state;
    }

    public PackControl() {
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PackControl packControl = PackControl.get(player2.getServer());
            player2.connection.send((CustomPacketPayload)new ClientboundUpdatePackControl(packControl.state));
        }
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"packcontrol").requires(source -> source.hasPermission(2))).then(PackControl.packUpdater("enable", (state, packId) -> state.setEnabled((String)packId, true)))).then(PackControl.packUpdater("disable", (state, packId) -> state.setEnabled((String)packId, false)))).then(PackControl.packUpdater("hide", (state, packId) -> state.setHidden((String)packId, true)))).then(PackControl.packUpdater("show", (state, packId) -> state.setHidden((String)packId, false))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> packUpdater(String name, BiFunction<State, String, State> updater) {
        return (LiteralArgumentBuilder)Commands.literal((String)name).then(Commands.argument((String)"pack", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String pack = StringArgumentType.getString((CommandContext)context, (String)"pack");
            PackControl.updateState(((CommandSourceStack)context.getSource()).getServer(), state1 -> (State)updater.apply((State)state1, pack));
            return 1;
        }));
    }

    public static void updateState(MinecraftServer server, UnaryOperator<State> operator) {
        PackControl packControl = PackControl.get(server);
        State newState = (State)operator.apply(packControl.state);
        if (packControl.state.equals(newState)) {
            return;
        }
        packControl.state = newState;
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            player.connection.send((CustomPacketPayload)new ClientboundUpdatePackControl(newState));
        }
        packControl.setDirty();
    }

    public record State(Set<String> hidden, Set<String> enabled) {
        public static final State DEFAULT = new State(Set.of(), Set.of());
        private static final Codec<Set<String>> PACK_SET_CODEC = Codec.STRING.listOf().xmap(Set::copyOf, List::copyOf);
        public static final Codec<State> CODEC = RecordCodecBuilder.create(i -> i.group((App)PACK_SET_CODEC.fieldOf("hidden").forGetter(State::hidden), (App)PACK_SET_CODEC.fieldOf("enabled").forGetter(State::enabled)).apply((Applicative)i, State::new));
        private static final StreamCodec<ByteBuf, Set<String>> PACK_SET_STREAM_CODEC = ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.collection(HashSet::new));
        public static final StreamCodec<ByteBuf, State> STREAM_CODEC = StreamCodec.composite(PACK_SET_STREAM_CODEC, State::hidden, PACK_SET_STREAM_CODEC, State::enabled, State::new);

        public State setHidden(String packId, boolean hidden) {
            return new State(State.setInSet(this.hidden, packId, hidden), this.enabled);
        }

        public State setEnabled(String packId, boolean enabled) {
            return new State(this.hidden, State.setInSet(this.enabled, packId, enabled));
        }

        private static <T> Set<T> setInSet(Set<T> set, T value, boolean inSet) {
            HashSet<T> newSet = new HashSet<T>(set);
            if (inSet) {
                newSet.add(value);
            } else {
                newSet.remove(value);
            }
            return newSet;
        }
    }
}

