/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data.poi;

import com.lovetropics.extras.registry.ExtraRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public record MapConfig(Component description, ResourceKey<Level> dimension, int minX, int minZ, int maxX, int maxZ, ResourceLocation texture) {
    public static final Codec<MapConfig> DIRECT_CODEC = RecordCodecBuilder.create(i -> i.group((App)ComponentSerialization.CODEC.fieldOf("description").forGetter(MapConfig::description), (App)Level.RESOURCE_KEY_CODEC.fieldOf("dimension").forGetter(MapConfig::dimension), (App)Codec.INT.fieldOf("min_x").forGetter(MapConfig::minX), (App)Codec.INT.fieldOf("min_z").forGetter(MapConfig::minZ), (App)Codec.INT.fieldOf("max_x").forGetter(MapConfig::maxX), (App)Codec.INT.fieldOf("max_z").forGetter(MapConfig::maxZ), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(MapConfig::texture)).apply((Applicative)i, MapConfig::new));
    public static final Codec<Holder<MapConfig>> CODEC = RegistryFixedCodec.create(ExtraRegistries.MAP);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<MapConfig>> STREAM_CODEC = ByteBufCodecs.holderRegistry(ExtraRegistries.MAP);

    public int markerX(BlockPos pos) {
        int width = this.maxX - this.minX;
        return (pos.getX() - this.minX) * 256 / width;
    }

    public int markerY(BlockPos pos) {
        int height = this.maxZ - this.minZ;
        return (pos.getZ() - this.minZ) * 256 / height;
    }
}

