/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data.poi;

import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.data.Named;
import com.lovetropics.extras.data.SimpleDataPackLister;
import com.lovetropics.extras.data.poi.MapManager;
import com.lovetropics.extras.data.poi.PoiConfig;
import com.lovetropics.extras.registry.ExtraRegistries;
import com.lovetropics.lib.codec.CodecRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber(modid="ltextras")
public class MapConfigs {
    public static final CodecRegistry<ResourceLocation, Named<PoiConfig>> POIS = CodecRegistry.resourceLocationKeys();
    private static final SimpleDataPackLister<PoiConfig> POI_LISTER = new SimpleDataPackLister<PoiConfig>("ltextras/map_poi", ExtraRegistries.POI, PoiConfig.CODEC);

    @SubscribeEvent
    public static void addReloadListener(AddServerReloadListenersEvent event) {
        RegistryAccess registries = event.getRegistryAccess();
        event.addListener(LTExtras.location("map_configs"), (barrier, resourceManager, backgroundExecutor, gameExecutor) -> ((CompletableFuture)POI_LISTER.load(registries, resourceManager, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).wait(arg_0))).thenAcceptAsync(pois -> {
            POIS.clear();
            pois.forEach(holder -> POIS.register((Object)holder.id(), holder));
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                MapManager.get(server).reload(server);
            }
        }, gameExecutor));
    }
}

