/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data.poi;

import com.google.common.collect.Sets;
import com.lovetropics.extras.data.Named;
import com.lovetropics.extras.data.poi.MapConfig;
import com.lovetropics.extras.data.poi.MapConfigs;
import com.lovetropics.extras.data.poi.PoiConfig;
import com.lovetropics.extras.network.message.ClientboundPoiFacesPacket;
import com.lovetropics.extras.network.message.ClientboundRemovePoiPacket;
import com.lovetropics.extras.network.message.ClientboundUpdatePoiPacket;
import com.lovetropics.extras.registry.ExtraRegistries;
import com.lovetropics.lib.permission.PermissionsApi;
import com.lovetropics.lib.permission.role.RoleOverrideType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PermissionsChangedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="ltextras")
public class MapManager
extends SavedData {
    public static final int MAP_SIZE = 256;
    public static final Codec<MapManager> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceKey.codec(ExtraRegistries.POI).listOf().fieldOf("disabled").forGetter(m -> List.copyOf(m.disabledPois))).apply((Applicative)i, disabledPois -> {
        MapManager mapManager = new MapManager();
        mapManager.disabledPois.addAll((Collection<ResourceKey<PoiConfig>>)disabledPois);
        return mapManager;
    }));
    private static final SavedDataType<MapManager> TYPE = new SavedDataType("ltextras_map_poi", MapManager::new, CODEC);
    private final Set<ResourceKey<PoiConfig>> disabledPois = new ObjectOpenHashSet();
    private Map<ResourceKey<PoiConfig>, Set<UUID>> facesByPoi = Map.of();
    private final Map<UUID, PlayerSender> playerSenders = new HashMap<UUID, PlayerSender>();

    public static MapManager get(MinecraftServer server) {
        return (MapManager)server.overworld().getDataStorage().computeIfAbsent(TYPE);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MapManager.get(player2.getServer()).onPlayerLoggedIn(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerPermissionsChanged(PermissionsChangedEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MapManager.get(player2.getServer()).refreshAccessiblePois(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MapManager.get(player2.getServer()).onPlayerLoggedOut(player2);
        }
    }

    private void onPlayerLoggedIn(ServerPlayer player) {
        this.playerSenders.put(player.getUUID(), new PlayerSender());
        this.refreshAccessiblePois(player);
    }

    private void onPlayerLoggedOut(ServerPlayer player) {
        this.playerSenders.remove(player.getUUID());
    }

    public void reload(MinecraftServer server) {
        if (this.disabledPois.removeIf(key -> !MapConfigs.POIS.containsKey((Object)key.location()))) {
            this.setDirty();
        }
        for (Map.Entry<UUID, PlayerSender> entry : this.playerSenders.entrySet()) {
            ServerPlayer player = server.getPlayerList().getPlayer(entry.getKey());
            if (player == null) continue;
            this.reloadForPlayer(entry.getValue(), player);
        }
    }

    private void reloadForPlayer(PlayerSender sender, ServerPlayer player) {
        sender.dropAll(player, key -> !MapConfigs.POIS.containsKey((Object)key.location()));
        for (Named holder : MapConfigs.POIS) {
            if (!this.isAccessibleFor(holder, player)) continue;
            sender.addOrUpdate(player, holder);
        }
    }

    @Nullable
    public Named<PoiConfig> getPoiAccessibleTo(ServerPlayer player, ResourceLocation id) {
        Named holder = (Named)MapConfigs.POIS.get((Object)id);
        return holder != null && this.isAccessibleFor(holder, player) ? holder : null;
    }

    private boolean isAccessibleFor(Named<PoiConfig> poi, ServerPlayer player) {
        return player.hasPermissions(2) || !this.disabledPois.contains(poi.key());
    }

    public Stream<ResourceKey<PoiConfig>> getAccessiblePois(ServerPlayer player) {
        return MapConfigs.POIS.stream().filter(holder -> this.isAccessibleFor((Named<PoiConfig>)holder, player)).map(Named::key);
    }

    public Stream<ResourceKey<PoiConfig>> getEnabledPois() {
        return MapConfigs.POIS.stream().map(Named::key).filter(key -> !this.disabledPois.contains(key));
    }

    public Stream<ResourceKey<PoiConfig>> getDisabledPois() {
        return this.disabledPois.stream();
    }

    public boolean enable(MinecraftServer server, ResourceKey<PoiConfig> id) {
        Named holder = (Named)MapConfigs.POIS.get((Object)id.location());
        if (holder == null) {
            return false;
        }
        boolean changed = this.disabledPois.remove(id);
        if (changed) {
            this.setDirty();
            this.refreshAccessiblePois(server);
            return true;
        }
        return false;
    }

    public boolean disable(MinecraftServer server, ResourceKey<PoiConfig> id) {
        Named holder = (Named)MapConfigs.POIS.get((Object)id.location());
        if (holder == null) {
            return false;
        }
        boolean changed = this.disabledPois.add(id);
        if (changed) {
            this.setDirty();
            this.refreshAccessiblePois(server);
            return true;
        }
        return false;
    }

    private void refreshAccessiblePois(ServerPlayer player) {
        PlayerSender sender = this.playerSenders.get(player.getUUID());
        if (sender == null) {
            return;
        }
        for (Named holder : MapConfigs.POIS) {
            if (this.isAccessibleFor(holder, player)) {
                sender.addOrUpdate(player, holder);
                continue;
            }
            sender.remove(player, holder.key());
        }
    }

    private void refreshAccessiblePois(MinecraftServer server) {
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            this.refreshAccessiblePois(player);
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Pre event) {
        MinecraftServer server = event.getServer();
        if (server.getTickCount() % 20 != 0) {
            return;
        }
        MapManager manager = MapManager.get(server);
        manager.updatePlayerFaces(server, MapManager.assignPlayerFaces(server.getPlayerList()));
    }

    private void updatePlayerFaces(MinecraftServer server, Map<ResourceKey<PoiConfig>, Set<UUID>> newFacesByPoi) {
        for (ResourceKey id : Sets.union(this.facesByPoi.keySet(), newFacesByPoi.keySet())) {
            Set oldFaces = this.facesByPoi.getOrDefault(id, Set.of());
            Set<UUID> newFaces = newFacesByPoi.getOrDefault(id, Set.of());
            if (newFaces.equals(oldFaces)) continue;
            for (Map.Entry<UUID, PlayerSender> entry : this.playerSenders.entrySet()) {
                ServerPlayer player = server.getPlayerList().getPlayer(entry.getKey());
                if (player == null) continue;
                entry.getValue().updateFaces(player, (ResourceKey<PoiConfig>)id, newFaces);
            }
        }
        this.facesByPoi = newFacesByPoi;
    }

    private static Map<ResourceKey<PoiConfig>, Set<UUID>> assignPlayerFaces(PlayerList playerList) {
        HashMap<ResourceKey<PoiConfig>, Set<UUID>> assignedFaces = new HashMap<ResourceKey<PoiConfig>, Set<UUID>>();
        for (ServerPlayer player : playerList.getPlayers()) {
            if (!FacePredicate.shouldDrawFace(player)) continue;
            MapConfigs.POIS.stream().filter(holder -> ((MapConfig)((PoiConfig)holder.value()).map().value()).dimension() == player.level().dimension()).min(Comparator.comparingDouble(holder -> ((PoiConfig)holder.value()).pos().distSqr((Vec3i)player.blockPosition()))).ifPresent(nearestPoi -> {
                Set facesForPoi = assignedFaces.computeIfAbsent(nearestPoi.key(), i -> new ObjectOpenHashSet());
                facesForPoi.add(player.getUUID());
            });
        }
        return assignedFaces;
    }

    private class PlayerSender {
        private static final int UNKNOWN_POI = -1;
        private final Object2IntMap<ResourceKey<PoiConfig>> knownPois = new Object2IntOpenHashMap();
        private int nextNetworkId;

        private PlayerSender() {
            this.knownPois.defaultReturnValue(-1);
        }

        public void addOrUpdate(ServerPlayer player, Named<PoiConfig> holder) {
            int networkId = this.knownPois.computeIfAbsent(holder.key(), i -> this.nextNetworkId++);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this.createUpdatePacket(networkId, holder.key(), holder.value()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        public void remove(ServerPlayer player, ResourceKey<PoiConfig> id) {
            int networkId = this.knownPois.removeInt(id);
            if (networkId != -1) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientboundRemovePoiPacket(networkId), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public void dropAll(ServerPlayer player, Predicate<ResourceKey<PoiConfig>> predicate) {
            this.knownPois.object2IntEntrySet().removeIf(entry -> {
                if (predicate.test((ResourceKey)entry.getKey())) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientboundRemovePoiPacket(entry.getIntValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    return true;
                }
                return false;
            });
        }

        private ClientboundUpdatePoiPacket createUpdatePacket(int networkId, ResourceKey<PoiConfig> id, PoiConfig config) {
            Component description = config.description();
            if (MapManager.this.disabledPois.contains(id)) {
                description = PlayerSender.lockedDescription(description);
            }
            MapConfig map = (MapConfig)config.map().value();
            int markerX = map.markerX(config.pos());
            int markerY = map.markerY(config.pos());
            return new ClientboundUpdatePoiPacket(networkId, id, config.map(), description, config.icon(), markerX, markerY);
        }

        private static Component lockedDescription(Component description) {
            return Component.empty().append((Component)Component.literal((String)"\ud83d\udd12 ").withStyle(ChatFormatting.RED)).append(description).withStyle(ChatFormatting.GRAY);
        }

        public void updateFaces(ServerPlayer player, ResourceKey<PoiConfig> id, Set<UUID> faces) {
            int networkId = this.knownPois.getInt(id);
            if (networkId != -1) {
                player.connection.send((CustomPacketPayload)new ClientboundPoiFacesPacket(networkId, List.copyOf(faces)));
            }
        }
    }

    private static class FacePredicate {
        private static final RoleOverrideType<Boolean> HOST_ROLE = RoleOverrideType.byId((String)"host");

        private FacePredicate() {
        }

        public static boolean shouldDrawFace(ServerPlayer player) {
            return PermissionsApi.lookup().byPlayer((Player)player).overrides().test(HOST_ROLE);
        }
    }
}

