/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data.spawnitems;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.data.spawnitems.SpawnItems;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;

@EventBusSubscriber(modid="ltextras")
public class SpawnItemsReloadListener
extends SimpleJsonResourceReloadListener<SpawnItems> {
    private static final ResourceKey<Registry<SpawnItems>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"spawn_items"));
    public static final BiMap<ResourceLocation, SpawnItems> REGISTRY = Maps.synchronizedBiMap((BiMap)HashBiMap.create());

    public SpawnItemsReloadListener(HolderLookup.Provider registries) {
        super(registries, SpawnItems.CODEC, REGISTRY_KEY);
    }

    @SubscribeEvent
    static void onAddReloadListeners(AddServerReloadListenersEvent event) {
        event.addListener(LTExtras.location("spawn_items"), (PreparableReloadListener)new SpawnItemsReloadListener((HolderLookup.Provider)event.getRegistryAccess()));
    }

    protected void apply(Map<ResourceLocation, SpawnItems> spawnItems, ResourceManager resourceManager, ProfilerFiller profiler) {
        REGISTRY.clear();
        REGISTRY.putAll(spawnItems);
    }
}

