/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data.spawnitems;

import com.lovetropics.extras.data.attachment.ExtraAttachments;
import com.lovetropics.extras.data.spawnitems.SpawnItems;
import com.lovetropics.extras.data.spawnitems.SpawnItemsReloadListener;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.slf4j.Logger;

@EventBusSubscriber(modid="ltextras")
public final class SpawnItemsStore {
    public static final MapCodec<SpawnItemsStore> MAP_CODEC = Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)SpawnItems.Stack.CODEC.listOf()).xmap(stacksById -> {
        SpawnItemsStore store = new SpawnItemsStore();
        stacksById.forEach((id, stacks) -> store.receivedItems.put((ResourceLocation)id, new ArrayList(stacks)));
        return store;
    }, store -> store.receivedItems).fieldOf("received_items");
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<ResourceLocation, List<SpawnItems.Stack>> receivedItems = new HashMap<ResourceLocation, List<SpawnItems.Stack>>();

    @SubscribeEvent
    static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SpawnItemsStore.sendItems(player2);
        }
    }

    private static void sendItems(ServerPlayer player) {
        SpawnItemsStore cap = SpawnItemsStore.get((Player)player);
        Map<ResourceLocation, List<SpawnItems.Stack>> diff = SpawnItemsStore.getDiff(player, cap.receivedItems);
        for (Map.Entry<ResourceLocation, List<SpawnItems.Stack>> entry : diff.entrySet()) {
            entry.getValue().forEach(stack -> {
                if (!player.addItem(stack.build())) {
                    player.level().addFreshEntity((Entity)player.drop(stack.build(), true, true));
                }
            });
            cap.receivedItems.computeIfAbsent(entry.getKey(), k -> new ArrayList()).addAll((Collection)entry.getValue());
        }
        LOGGER.debug("Sent spawn items from {} sets to player {}: {}", new Object[]{diff.size(), player, diff.keySet()});
    }

    @SubscribeEvent
    static void onReloadResources(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            LOGGER.debug("Sending spawn items to all players after reload...");
            event.getPlayerList().getPlayers().forEach(SpawnItemsStore::sendItems);
        }
    }

    private static Map<ResourceLocation, List<SpawnItems.Stack>> getDiff(ServerPlayer player, Map<ResourceLocation, List<SpawnItems.Stack>> old) {
        HashMap<ResourceLocation, List<SpawnItems.Stack>> diff = new HashMap<ResourceLocation, List<SpawnItems.Stack>>();
        SpawnItemsReloadListener.REGISTRY.forEach((location, items) -> {
            List oldReceived = old.getOrDefault(location, List.of());
            if (items.canApplyToPlayer(player)) {
                diff.put((ResourceLocation)location, items.items().stream().filter(Predicate.not(oldReceived::contains)).toList());
            }
        });
        return diff;
    }

    @SubscribeEvent
    static void onPlayerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        if (oldPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)oldPlayer;
            if (event.isWasDeath() && !((GameRules.BooleanValue)serverPlayer.level().getGameRules().getRule(GameRules.RULE_KEEPINVENTORY)).get()) {
                return;
            }
            SpawnItemsStore oldStore = SpawnItemsStore.get(oldPlayer);
            SpawnItemsStore newStore = SpawnItemsStore.get(event.getEntity());
            newStore.receivedItems.putAll(oldStore.receivedItems);
        }
    }

    public static SpawnItemsStore get(Player player) {
        return (SpawnItemsStore)player.getData(ExtraAttachments.SPAWN_ITEMS_STORE);
    }
}

