/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.effect;

import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.effect.FishEyeEffect;
import com.lovetropics.extras.effect.ForkliftBoostEffect;
import com.lovetropics.extras.effect.ModelEffect;
import com.lovetropics.extras.effect.PropaguledEffect;
import com.lovetropics.extras.model_modifer.ModelModifierStore;
import com.lovetropics.extras.model_modifer.ModelModifierType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class ExtraEffects {
    public static final DeferredRegister<MobEffect> REGISTER = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"ltextras");
    public static final DeferredHolder<MobEffect, FishEyeEffect> FISH_EYE = REGISTER.register("fish_eye", () -> new FishEyeEffect(MobEffectCategory.BENEFICIAL, 7723007));
    public static final DeferredHolder<MobEffect, ForkliftBoostEffect> FORKLIFT_BOOST = REGISTER.register("forklift_boost", () -> new ForkliftBoostEffect(MobEffectCategory.BENEFICIAL, 0x75F7FF));
    public static final DeferredHolder<MobEffect, PropaguledEffect> PROPAGULED = REGISTER.register("propaguled", () -> new PropaguledEffect(MobEffectCategory.HARMFUL, 56780).addAttributeModifier(Attributes.MOVEMENT_SPEED, LTExtras.location("effects.propaguled"), (double)-0.15f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Map<ModelModifierType, DeferredHolder<MobEffect, ModelEffect>> MODEL_EFFECTS = new HashMap<ModelModifierType, DeferredHolder<MobEffect, ModelEffect>>();

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        ExtraEffects.removeModelModifiers((MobEffect)event.getEffect().value(), event.getEntity());
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Expired event) {
        ExtraEffects.removeModelModifiers((MobEffect)event.getEffectInstance().getEffect().value(), event.getEntity());
    }

    private static void removeModelModifiers(MobEffect mobEffect, LivingEntity entity) {
        if (mobEffect instanceof ModelEffect) {
            ModelEffect modelEffect = (ModelEffect)mobEffect;
            ModelModifierStore.removeModifier((Entity)entity, modelEffect.getType());
        }
    }

    static {
        for (ModelModifierType value : ModelModifierType.values()) {
            if (value.getEffectName() == null) continue;
            ModelEffect modelEffect = new ModelEffect(MobEffectCategory.NEUTRAL, 0, value);
            if (value == ModelModifierType.SHRUGGY_ARMS) {
                modelEffect.addAttributeModifier(Attributes.BLOCK_INTERACTION_RANGE, LTExtras.location("small_arms_block_range"), -3.0, AttributeModifier.Operation.ADD_VALUE);
                modelEffect.addAttributeModifier(Attributes.ENTITY_INTERACTION_RANGE, LTExtras.location("small_arms_entity_range"), -3.0, AttributeModifier.Operation.ADD_VALUE);
            } else if (value == ModelModifierType.ENDER_ARMS) {
                modelEffect.addAttributeModifier(Attributes.BLOCK_INTERACTION_RANGE, LTExtras.location("long_arms_block_range"), 3.0, AttributeModifier.Operation.ADD_VALUE);
                modelEffect.addAttributeModifier(Attributes.ENTITY_INTERACTION_RANGE, LTExtras.location("long_arms_entity_range"), 3.0, AttributeModifier.Operation.ADD_VALUE);
            }
            MODEL_EFFECTS.put(value, (DeferredHolder<MobEffect, ModelEffect>)REGISTER.register("mm_" + value.getSerializedName(), () -> modelEffect));
        }
    }
}

